<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CustomField extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'custom_fields';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['name', 'module_id', 'field_type_id', 'field_values', 'after_amount', 'sort_order', 'status', 'user_id'];

    public function module()
    {
        return $this->belongsTo('App\Module');
    }
    
    public function fieldType()
    {
        return $this->belongsTo('App\CustomFieldType');
    }
}
