<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Banking;
use App\MobileOrder;
use App\SimOrder;
use App\UnlockingMobile;
use App\ReferralUser;
use App\UserBalance;
use Illuminate\Http\Request;
use Session, DB;
use Carbon\Carbon;
use App\Classes\USmartApiClass;

class AdminController extends Controller
{    
    public function dashboard()
    {
        $bankingCount = Banking::where('approved', 0)->count();

        $mobileOrderCount = MobileOrder::select('id')->where('delivered', 0)->groupBy('transaction_id')->get();       
        
        $simOrderCount = SimOrder::select('id')->where('delivered', 0)->groupBy('transaction_id')->get();
        
        $userCount = \App\User::where('activated', 0)->count();
        
        $banking = Banking::where('approved', 0)->take(5)->orderBy('date', 'desc')->get();

        $mobileOrder = MobileOrder::select(\DB::raw('mobile_orders.*, SUM(quantity) as quantity, SUM(price) as total'))
                        ->where('delivered', 0)->take(5)->groupBy('transaction_id')->orderBy('created_at', 'desc')->get();
        
        $simOrder = SimOrder::select(\DB::raw('sim_order.*, SUM(quantity) as quantity'))
                        ->where('delivered', 0)->take(5)->groupBy('transaction_id')->orderBy('created_at', 'desc')->get();
        
        $unlockingMobile = UnlockingMobile::where('status', 0)->orWhere('status', 3)->take(5)->orderBy('created_at', 'desc')->get();
        
        $professionalService = ReferralUser::where('status', 0)->take(5)->orderBy('created_at', 'desc')->get();
        
        return view('admin.default', compact('bankingCount', 'mobileOrderCount', 'simOrderCount', 'userCount', 'banking', 'mobileOrder', 'simOrder', 'unlockingMobile', 'professionalService'));
    }
    
    public function bankingApproved(Request $request)
    {
        $where['id'] = $request['id'];
        
        $result = Banking::where($where)->update(array('approved' => $request['approved']));// 0 => Pending, 1 => Approved, 2 => Reject
        
        $message = ($request['approved'] == 1)?'Approved!':'Reject!';
        
        if($result > 0)
        {
            if($request['approved'] == 1)
            {
                $banking = Banking::where($where)->first();

                DB::table('users')->where('id', $banking->user_id)->increment('balance', $banking->amount);
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            return response()->json(['message' => 'Not '.$message]);
        }
    }
    
    public function mobileOrderList()
    {
        $mobileOrders = MobileOrder::select(\DB::raw('mobile_orders.*, SUM(quantity) as quantity, SUM(price) as total'))
                        ->where('delivered', 0)->groupBy('transaction_id')->orderBy('created_at', 'desc')->get();
        
        return view('admin.mobile_order_list', compact('mobileOrders'));
    }
    
    public function mobileOrderDetail($transactionId)
    {
        $where['transaction_id'] = $transactionId;
        
        $mobileOrders = MobileOrder::where($where)->orderBy('created_at', 'desc')->get();
        
        return view('admin.mobile_order_detail', compact('mobileOrders'));
    }
    
    public function mobileDelivered(Request $request)
    {
        $where['transaction_id'] = $request['transaction_id'];
        
        $result = MobileOrder::where($where)->update(array('delivered' => $request['delivered']));// 0 => Pending, 1 => Delivered, 2 => Cancel
        
        if($result > 0)
        {
            if($request['delivered'] == 2)
            {
                $mobileOrder = MobileOrder::where($where)->select(\DB::raw('mobile_orders.user_id, SUM(price) as total'))->first();
                
                $userId = $mobileOrder->user_id;
                $amount = $mobileOrder->total;
                $action = 'Refund Mobile Order (Order No: '.$mobileOrder->transaction_id.')';
                
                $this->addBalance($amount, $action, $userId);
            }
            
            Session::flash('flash_message', 'Status updated!');
            return response()->json(['response' => 'success']);
        }else
        {
            return response()->json(['message' => 'Not status updated!']);
        }
    }
    
    public function simOrderList()
    {
        $simOrders = SimOrder::select(\DB::raw('sim_order.*, SUM(quantity) as quantity'))
                        ->where('delivered', 0)->groupBy('transaction_id')->orderBy('created_at', 'desc')->get();
        
        return view('admin.sim_order_list', compact('simOrders'));
    }
    
    public function simOrderDetail($transactionId)
    {
        $where['transaction_id'] = $transactionId;
        
        $simOrders = SimOrder::where($where)->orderBy('created_at', 'desc')->get();
        
        return view('admin.sim_order_detail', compact('simOrders'));
    }
    
    public function simDelivered(Request $request)
    {
        $where['transaction_id'] = $request['transaction_id'];
        
        $result = SimOrder::where($where)->update(array('delivered' => $request['delivered']));// 0 => Pending, 1 => Delivered, 2 => Cancel
        
        if($result > 0)
        {            
            Session::flash('flash_message', 'Status updated!');
            return response()->json(['response' => 'success']);
        }else
        {
            return response()->json(['message' => 'Not status updated!']);
        }
    }  

    public function unlockingMobileDetail($id)
    {
        $where['id'] = $id;
        
        $unlockingMobile = UnlockingMobile::where($where)->first();
        
        return view('admin.unlocking_mobile_detail', compact('unlockingMobile'));
    }
    
    public function unlockingMobileStatusUpdate(Request $request)
    {
        $requestData = $request->except(['_token', 'id', 'list', 'refund']);
        $where['id'] = $request['id'];
       
        $result = UnlockingMobile::where($where)->update($requestData);// 0 => Pending, 1 => Completed, 2 => Reject, 3 => In Process, 4 => Cancel
        
        if($result > 0)
        {
            $this->sendUnlockingMobileEmail($request['id'], $request['refund']);
            
            Session::flash('flash_message', 'Status updated!');
            return response()->json(['response' => 'success']);
        }else
        {
            return response()->json(['message' => 'Not status updated!']);
        }
    }
    
    public function processUnlockingMobile()
    {
        $currnetTime = Carbon::now();
        $where['status'] = 0;
        
        $unlockingMobiles = UnlockingMobile::where($where)->whereNull('order_id')->get();
        
        foreach($unlockingMobiles as $row):
            
            if($row->service->api_id != '')
            {
                $orderId = '';
                $response = array();
                $responseDuplicate = array();
                $api = $row->service->api->user_name.'(Unlocking Mobile)';
                
                $uSmartApiClass = new USmartApiClass($row->service->api->api, $row->service->api->user_name, $row->service->api->url);
                $uSmartApiClass->doAction('placeorder', array('imei' => $row->imei_number, 'networkId' => $row->service->api_service_id));

                $apiResult = $uSmartApiClass->getResult();

                $this->unlockingMobileApiResponse($orderId, $apiResult, $api);
                
                $uSmartApiClass->XmlToArray($apiResult);
                $arrayData = $uSmartApiClass->createArray();
                
                if(isset($arrayData['error']) && sizeof($arrayData['error']) > 0)
                {
                    if($arrayData['error'][0] == 'IMEI already exists!')
                    {    
                        $result = UnlockingMobile::where(array('id' => $row->id))->update(array('status' => 2, 'response' => $arrayData['error'][0]));// 0 => Pending, 1 => Completed, 2 => Reject, 3 => In Process, 4 => Cancel

                        if($result > 0)
                        {
                            $this->sendUnlockingMobileEmail($row->id, 1);
                        }
                    }
                    exit();
                }
            
                if(isset($arrayData['result']['imeis']) && sizeof($arrayData['result']['imeis']) > 0)
                {
                    $response = $arrayData['result']['imeis'];
                }

                if(isset($arrayData['result']['imeiduplicates']) && sizeof($arrayData['result']['imeiduplicates']) > 0)
                {
                    $responseDuplicate = $arrayData['result']['imeiduplicates'];
                }

                $total = count($response);
                if($total > 0)
                {
                    for($count = 0; $count < $total; $count++)
                    {
                        $orderId = $response[$count]['id'];
                        $status  = getUnlockingMobileStatus($response[$count]['status']);
                        $imei    = $response[$count]['imei'];		
                        
                        $newStatus = ($status == 0)?3:$status;
                        $result = UnlockingMobile::where(array('id' => $row->id, 'imei_number' => $imei))->update(array('status' => $newStatus, 'order_id' => $orderId));// 0 => Pending, 1 => Completed, 2 => Reject, 3 => In Process, 4 => Cancel

                        if($result > 0)
                        { 
                            $this->sendUnlockingMobileEmail($row->id, 0);
                        }
                    }
                }

                $total_errors = count($responseDuplicate);

                if($total_errors > 0)
                {
                    $arrDupImeis = explode(',', $responseDuplicate[0]['imei']);
                    $totalDupImeis = count($arrDupImeis);
                    for($count = 0; $count < $totalDupImeis; $count++)
                    {
                        $arrDupImeis[$count];
                    }
                }
                
                if($orderId != '')
                {
                    $this->unlockingMobileApiResponse($orderId, $apiResult, $api);
                }
            }else
            {
                $createdAt = Carbon::createFromFormat('d/m/Y H:i:s', $row->created_at)->format('Y-m-d H:i:s');
                $processAfter = $row->service->process_after;

                $dt = Carbon::parse($createdAt);
                $updatedTime = $dt->addMinutes($processAfter);

                if($updatedTime <= $currnetTime)
                {
                    $result = UnlockingMobile::where('id', $row->id)->update(array('status' => 3));// 0 => Pending, 1 => Completed, 2 => Reject, 3 => In Process, 4 => Cancel

                    if($result > 0)
                    { 
                        $this->sendUnlockingMobileEmail($row->id, 0);
                    }
                }
            }
            
        endforeach;
        
        $unlockingMobile = UnlockingMobile::whereNotIn('status', [1,2])->whereNotNull('order_id')->get();
        
        foreach($unlockingMobile as $row):
        
            $response = array();
            $orderId = $row->order_id;
            $api = $row->service->api->user_name.'(Unlocking Mobile)';
            
            $uSmartApiClass = new USmartApiClass($row->service->api->api, $row->service->api->user_name, $row->service->api->url);
            $uSmartApiClass->doAction('getimeis', array('orderIds' => $orderId));
        
            $apiResult = $uSmartApiClass->getResult();
            
            $this->unlockingMobileApiResponse($orderId, $apiResult, $api);
            
            $uSmartApiClass->XmlToArray($apiResult);
            $arrayData = $uSmartApiClass->createArray();

            if(isset($arrayData['error']) && sizeof($arrayData['error']) > 0)
            {
                exit;
            }

            if(isset($arrayData['result']['imeis']) && sizeof($arrayData['result']['imeis']) > 0)
            {
                $response = $arrayData['result']['imeis'];
            }
            
            if(isset($response[0]['status']) && $response[0]['status'] != '')
            {
                $status = getUnlockingMobileStatus($response[0]['status']);
                
                $newStatus = ($status == 0)?3:$status;
                
                $result = UnlockingMobile::where(array('id' => $row->id, 'order_id' => $row->order_id))->where('status', '!=', $newStatus)->update(array('status' => $status, 'response' => $response[0]['code']));// 0 => Pending, 1 => Completed, 2 => Reject, 3 => In Process, 4 => Cancel

                if($result > 0)
                { 
                    $this->sendUnlockingMobileEmail($row->id, 1);
                }
            }
            
        endforeach;
    }
    
    private function sendUnlockingMobileEmail($id, $refund)
    {
        $mailer = \App::make('jmailer');

        $viewFile = 'mail.unlocking_mobile';

        $previousBalance = 0;
        $currentBalance  = 0;
        
        $unlockingMobile = UnlockingMobile::where('id', $id)->first();
        
        $userName = getUserName($unlockingMobile);
        $email = $unlockingMobile->user->email;
        $companyLogo = ($unlockingMobile->userProfile->company_logo != '')?'images/company_profiles/'.$unlockingMobile->userProfile->company_logo:'packages/mnr_ehub/img/print_logo.png';
        $header = ($unlockingMobile->userProfile->header != '')?$unlockingMobile->userProfile->header:'';
    
        $transactionId = $unlockingMobile->transaction_id;
        $amount = $unlockingMobile->price;
        $status = $unlockingMobile->status;
        $userId = $unlockingMobile->user_id;
        $action = 'Refund Unlocking Mobile due to reject order (Order No: '.$transactionId.')';

        if($status != 0)
        {
            if($status == 2 && $refund == 1)
            {
                $previousBalance = $unlockingMobile->user->balance;
                $currentBalance  = $previousBalance + $amount;

                $this->addBalance($amount, $action, $userId);
            }

            if($status == 1)
            {
                $subject = 'Response for your order : '.$transactionId.' Order Completed';
            }else if($status == 2)
            {
                $subject = 'Response for your order : '.$transactionId.' Order Rejected';
            }else if($status == 3)
            {
                $subject = 'Response for your order : '.$transactionId.' Order In Process';
            }

            $body['user_name']        = $userName;
            $body['company_logo']     = $companyLogo;
            $body['header']           = $header;
            $body['email']            = $email;
            $body['imei']             = $unlockingMobile->imei_number;
            $body['order_no']         = $transactionId;
            $body['order_date']       = $unlockingMobile->created_at;
            $body['previous_balance'] = $previousBalance;
            $body['current_balance']  = $currentBalance;
            $body['service']          = $unlockingMobile->service->name;
            $body['amount']           = $amount;
            $body['status']           = $status;
            $body['response']         = $unlockingMobile->response;

            // send email to client
            $mailer->sendTo($email, $body, $subject, $viewFile);

            // send email to Admin
            $mailer->sendTo(getGlobalValue('superadmin_email'), $body, $subject, $viewFile);
            
            if($status == 1 || $status == 2)
            {
                if($unlockingMobile->send_sms == 1)
                {
                    $this->sendUnlockingMobileSMS($unlockingMobile, $subject);
                }
            }
        }
    }
    
    private function sendUnlockingMobileSMS($unlockingMobile, $subject)
    {
        $userName = getUserName($unlockingMobile);
        
        $mobile = getProfile()->mobile_no;
        $message = $subject.'\n
                    Dear '.$userName.'\n
                    Order Information\n
                        Order #: '.$unlockingMobile->transaction_id.'\n
                        Order Date: '.$unlockingMobile->created_at.'\n
                        Service: '.$unlockingMobile->service->name.'\n
                        IMEI: '.$unlockingMobile->imei_number.'\n
                        Amount: '.getGlobalValue('currency').$unlockingMobile->price.'\n
                        Response: '.$unlockingMobile->response;

//        $result = Twilio::message($mobile, $message);
    }
    
    private function unlockingMobileApiResponse($orderId, $result, $api)
    {
        $data['transaction_id'] = $orderId;
        $data['response']       = $result;
        $data['api']            = $api;
        $data['user_id']        = 1;

        \App\ApiResponse::create($data);
    }
    
    public function courierStatusUpdate(Request $request)
    {
        $page      = $request['page'];
        $type      = $request['type'];
        $cargoType = $request['cargo_type'];
        $dateFrom  = $request['date_from'];
        $dateTo    = $request['date_to'];
        $country   = $request['country'];
        $status    = $request['status'];
        $trackingNumber = $request['tracking_number'];
        
        $userId = $this->userId($request['user_id'], $page);
        
        if($type == 1):
           $table = 'courier_service';
           $field = 'total_price';
        elseif($type == 2):
            $table = 'cargo_service';
            $field = 'total';
        endif;
        
        $data['status'] = $status;
        
        if($status == 1)
        {
            $data['tracking_number'] = $trackingNumber;
        }
        
        $parcelInformation = \App\ParcelInformation::join($table, 'parcel_informations.id', '=', $table.'.parcel_information_id')
                    ->join('addresses', 'parcel_informations.delivery_id', '=', 'addresses.id')
                    ->select('parcel_informations.id')
                    ->where(function ($query) use($cargoType, $userId, $dateFrom, $dateTo, $country, $status)
                    {
                        if($cargoType != '')
                        {
                            $query->where('cargo_type', $cargoType);
                        }

                        if($userId != '')
                        {
                            $query->where('parcel_informations.user_id', $userId);
                        }

                        if($country != '')
                        {
                            $query->where('country', $country);
                        }

                        if($dateFrom != '' && $dateTo != '')
                        {
                            $from = $this->dateFrom($dateFrom);
                            $to   = $this->dateTo($dateTo);
                            $query->whereBetween('parcel_informations.created_at', array($from, $to));
                        }
                        
                        if($status == 1)
                        {
                            $query->where('status', 0);
                        }
                        else if($status == 2)
                        {
                            $query->where('status', 1);
                        }
                    })->get();
        
        $id = $parcelInformation->toArray();
        $result = \App\ParcelInformation::whereIn('id', $id)->update($data);
        
        if($result > 0)
        {
            Session::flash('flash_message', 'Status updated!');
            return response()->json(['response' => 'success']);
        }else
        {
            return response()->json(['message' => 'Not status updated!']);
        }
    }
    
    private function dateFrom($dateFrom)
    {
        if($dateFrom == '')
        {
            $from = date('Y-m-d 00:00:00');
        }else
        {
            $from = getDateFrom($dateFrom);
        }
        
        return $from;
    }
    
    private function dateTo($dateTo)
    {
        if($dateTo == '')
        {
            $to = date('Y-m-d 23:59:59');
        }else
        {
            $to = getDateTo($dateTo);
        }
        
        return $to;
    }
    
    private function userId($userId, $page)
    {
        //Page 1 for Admin Page 2 for Agent
        if(userGroup() == 'agent')
        {
            $userId = userId();
        }else if($page == 2 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
        {
            $userId = userId();
        }
        
        return $userId;
    }
    
    public function userBalanceHistory($userId)
    {
        $where['user_id'] = $userId;
        $userBalance = \App\UserBalance::where($where)->orderBy('created_at', 'desc')->get();
        
        return view('admin.user_balance_history', compact('userBalance'));
    }
    
    public function paymentMethodResponse()
    {
        $paymentMethodResponse = \App\PaymentMethodResponse::orderBy('created_at', 'desc')->get();
        
        return view('admin.payment_method_response', compact('paymentMethodResponse'));
    }
    
    private function addBalance($amount, $action, $userId)
    {
        $data['amount']  = $amount;
        $data['action']  = $action;
        $data['user_id'] = $userId;

        UserBalance::create($data);

        $where['id'] = $userId;

        DB::table('users')->where($where)->increment('balance', $amount);
    }
}
