<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Bank;
use Illuminate\Http\Request;
use Session;

class BanksController extends Controller
{    
//    public function __construct(Request $request)
//    {
//        if(!$request->ajax())
//        {
//            redirect('/admin')->send();
//        }
//    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $banks = Bank::get();

        return view('banks.index', compact('banks'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('banks.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name'  => 'required|alpha_dash_space|max:30|unique:banks',
            'image' => 'image|mimes:jpeg,png,jpg,gif|max:200' //KB
        ]);
        
        $image = $request->file('image');
        
        if($image != '')
        {
            $fileName = md5(uniqid()).'.'.$image->getClientOriginalExtension();
            $image->move('images/bank_images/', $fileName);
            
            $request['image_name'] = $fileName;
        }
        
        $request['user_id'] = userId();
        $requestData = $request->except(['image']);
        
        Bank::create($requestData);

        Session::flash('flash_message', 'Bank added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $bank = Bank::findOrFail($id);

        return view('banks.edit', compact('bank'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'name'  => 'required|alpha_dash_space|max:30|unique:banks,name,'.$id,
            'image' => 'image|mimes:jpeg,png,jpg,gif|max:200',
        ]);
        
        $image = $request->file('image');
        
        if($image != '')
        {
            if($request['image_name'] == '')
            {
                $fileName = md5(uniqid()).'.'.$image->getClientOriginalExtension();
            }else
            {
                $fileName = $request['image_name'];
            }
            
            $image->move('images/bank_images/', $fileName);
            
            $request['image_name'] = $fileName;
        }
        
        $request['user_id'] = userId();
        $requestData = $request->except(['image']);
        
        $bank = Bank::findOrFail($id);
        $bank->update($requestData);

        Session::flash('flash_message', 'Bank updated!');

        return response()->json(['response' => 'success']);
    }
    
    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = Bank::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }
}
