<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Config;
use Illuminate\Http\Request;
use Session;

class ConfigsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return void
     */
    public function index()
    {
        $configs = Config::get();
        
        return view('configs.index', compact('configs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return void
     */
    public function create()
    {
        return view('configs.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return void
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'config_key'   => 'required|alpha_dash|max:30|unique:configs',
            'config_value' => 'required',
            'type'         => 'required|alpha'
        ]);

        $request['user_id'] = userId();
        Config::create($request->all());

        Session::flash('flash_message', 'Config added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return void
     */
    public function edit($id)
    {
        $config = Config::findOrFail($id);

        return view('configs.edit', compact('config'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     *
     * @return void
     */
    public function update($id, Request $request)
    {
        if($request['type'] == 'digits')
        {
            $validation['config_value'] = 'required|digits_between:1,5';
        }else if($request['type'] == 'decimal')
        {
            $validation['config_value'] = 'required|numeric';
        }else if($request['type'] == 'email')
        {
            $validation['config_value'] = 'required|email';
        }else
        {
            $validation['config_value'] = 'required';
        }
        
        $this->validate($request, $validation);

        $config = config::findOrFail($id);
        $config->update($request->except(['config_key', 'type']));

        Session::flash('flash_message', 'Config updated!');

        return response()->json(['response' => 'success']);
    }
    
    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = Config::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }  
}
