<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\MobileProduct;
use Illuminate\Http\Request;
use Session;

class MobileProductsController extends Controller
{
//    public function __construct(Request $request)
//    {
//        if(!$request->ajax())
//        {
//            redirect('/admin')->send();
//        }
//    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $products = MobileProduct::get();

        return view('mobile_products.index', compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('mobile_products.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name'            => 'required|alpha_dash_space|max:100|unique:mobile_products',
            'brand_id'        => 'required',
            'new_quantity'    => 'required|digits_between:1,5',
            'refurb_quantity' => 'required|digits_between:1,5',
            'price'           => 'required|numeric',
            'image'           => 'image|mimes:jpeg,png,jpg,gif|max:200' //KB
        ]);
        
        $image = $request->file('image');
        
        if($image != '')
        {
            $fileName = md5(uniqid()).'.'.$image->getClientOriginalExtension();
            $image->move('images/mobile_images', $fileName);
            
            $request['image_name'] = $fileName;
        }
        
        $request['user_id'] = userId();
        $requestData = $request->except(['image']);
        
        MobileProduct::create($requestData);

        Session::flash('flash_message', 'Product added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $product = MobileProduct::findOrFail($id);

        return view('mobile_products.edit', compact('product'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'name'            => 'required|alpha_dash_space|max:100|unique:mobile_products,name,'.$id,
            'brand_id'        => 'required',
            'new_quantity'    => 'required|digits_between:1,5',
            'refurb_quantity' => 'required|digits_between:1,5',
            'price'           => 'required|numeric',
            'image'           => 'image|mimes:jpeg,png,jpg,gif|max:200',
        ]);
        
        $image = $request->file('image');
        
        if($image != '')
        {
            if($request['image_name'] == '')
            {
                $fileName = md5(uniqid()).'.'.$image->getClientOriginalExtension();
            }else
            {
                $fileName = $request['image_name'];
            }
            
            $image->move('images/mobile_images', $fileName);
            
            $request['image_name'] = $fileName;
        }
        
        $request['user_id'] = userId();
        $requestData = $request->except(['image']);
        
        $product = MobileProduct::findOrFail($id);
        $product->update($requestData);

        Session::flash('flash_message', 'Product updated!');

        return response()->json(['response' => 'success']);
    }
    
    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = MobileProduct::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }
}
