<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Product;
use Illuminate\Http\Request;
use Session;

class ProductsController extends Controller
{
//    public function __construct(Request $request)
//    {
//        if(!$request->ajax())
//        {
//            redirect('/admin')->send();
//        }
//    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $products = Product::get();

        return view('products.index', compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('products.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name'          => 'required|alpha_dash_space|max:30|unique:products',
            'category_id'   => 'required',
            'image'         => 'image|mimes:jpeg,png,jpg,gif|max:200', //KB
            'amount.*'      => 'required',
            'cost_price.*'  => 'required',
            'agent_price.*' => 'required',
            'description'   => 'required'
        ]);
        
        $image = $request->file('image');
        
        if($image != '')
        {
            $fileName = md5(uniqid()).'.'.$image->getClientOriginalExtension();
            $image->move('images/product_images', $fileName);
            
            $request['image_name'] = $fileName;
        }
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $product = Product::create($requestData);

        $amount = $request['amount'];
        $costPrice  = $request['cost_price'];
        $agentPrice = $request['agent_price'];
        
        foreach($amount as $key => $value)
        {
            $data[$value] = ['cost_price' => $costPrice[$key], 'agent_price' => $agentPrice[$key]];
        }

        $product->amounts()->sync($data);
        
        Session::flash('flash_message', 'Product added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $product = Product::findOrFail($id);
        
        return view('products.edit', compact('product'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'name'          => 'required|alpha_dash_space|max:30|unique:products,name,'.$id,
            'category_id'   => 'required',
            'image'         => 'image|mimes:jpeg,png,jpg,gif|max:200', //KB
            'amount.*'      => 'required',
            'cost_price.*'  => 'required',
            'agent_price.*' => 'required',
            'description'   => 'required'
        ]);
        
        $image = $request->file('image');
        
        if($image != '')
        {
            if($request['image_name'] == '')
            {
                $fileName = md5(uniqid()).'.'.$image->getClientOriginalExtension();
            }else
            {
                $fileName = $request['image_name'];
            }
            
            $image->move('images/product_images', $fileName);
            
            $request['image_name'] = $fileName;
        }
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $product = Product::findOrFail($id);
        $product->update($requestData);
        
        $amount = $request['amount'];
        $costPrice  = $request['cost_price'];
        $agentPrice = $request['agent_price'];
        
        foreach($amount as $key => $value)
        {
            $data[$value] = ['cost_price' => $costPrice[$key], 'agent_price' => $agentPrice[$key]];
        }

        $product->amounts()->sync($data);
        
        Session::flash('flash_message', 'Product updated!');

        return response()->json(['response' => 'success']);
    }
    
    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = Product::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }
    
    public function getAmount($productId)
    {
        echo getProductAmount($productId);
    }
}
