<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\PaymentMethodResponse;
use App\UserBalance;
use Illuminate\Http\Request;
use Session, DB, Stripe;

class ResponseController extends Controller
{
    public function instantCreditStore(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'amount' => 'required|numeric|min:100',
        ]);

        if ($validator->fails()) 
        {
            return redirect('transactions/instant_credit')
                        ->withErrors($validator)
                        ->withInput();
        }
        
        $amount = $request['amount'];
        $pament_method = $request['payment_method'];
        
        if($pament_method == 'stripe')
        {
            $title = 'Instant Credit By Stripe';
            $where['user_id'] = userId();
            
            $userCreditCard = \App\UserCreditCard::where($where)->get();
                    
            return view('transactions.instant_credit_stripe', compact('title', 'amount', 'userCreditCard'));
            
        }else if($pament_method == 'paypal')
        {
            return view('transactions.paypal', compact('amount'));
        }
    }
    
    public function stripeStore(Request $request)
    {
        $status = 0;
        $transactionId = '';
        $cardId = $request['card'];
        
        $validation = [
            'card'   => 'required',
            'amount' => 'required|numeric|min:100',
        ];
        
        $this->validate($request, $validation);
        
        if($cardId == 0)
        {        
            $validation_1 = [
                'first_name'      => 'required|alpha_dash_space|max:100',
                'last_name'       => 'required|alpha_dash_space|max:100',
                'card_number'     => 'required|digits:16|unique:user_credit_card',
                'brand'           => 'required|max:20',
//                'exp_month'       => 'required|digits:4',
//                'exp_year'        => 'required|digits_between:1,2',
                'cvc'             => 'required|digits:3',
//                'address_line_1'  => 'required|max:255',
//                'address_line_2'  => 'required|max:255',
//                'address_city'    => 'required|max:100',
//                'address_zip'     => 'required|max:45',
//                'address_country' => 'required',
            ];    
            
            $this->validate($request, $validation_1);
        }
        
        if($cardId == 0)
        {
            $card['number']          = $request['card_number'];
            $card['cvc']             = $request['cvc'];
            $card['exp_month']       = $request['exp_month'];
            $card['exp_year']        = $request['exp_year'];
            $card['name']            = $request['first_name'].' '.$request['last_name'];
//            $card['address_line1']   = $request['address_line_1'];
//            $card['address_line2']   = $request['address_line_2'];
//            $card['address_city']    = $request['address_city'];
//            $card['address_zip']     = $request['address_zip'];
//            $card['address_country'] = $request['address_country'];            
        }  else 
        {
            $where['id']      = $cardId;
            $where['user_id'] = userId();
            
            $userCreditCard = \App\UserCreditCard::where($where)->first();
            
            $card['number']          = $userCreditCard->card_number;
            $card['cvc']             = $userCreditCard->cvc;
            $card['exp_month']       = $userCreditCard->exp_month;
            $card['exp_year']        = $userCreditCard->exp_year;
            $card['name']            = $userCreditCard->first_name.' '.$userCreditCard->last_name;
//            $card['address_line1']   = $userCreditCard->address_line_1;
//            $card['address_line2']   = $userCreditCard->address_line_2;
//            $card['address_city']    = $userCreditCard->address_city;
//            $card['address_zip']     = $userCreditCard->address_zip;
//            $card['address_country'] = $userCreditCard->address_country;
            
            unset($where);
        }
                
        try 
        {
            Stripe::setApiKey(env('STRIPE_SECRET'));       
            $result = Stripe::charges()->create(
                array(
                    "amount"      => $request['amount'],
                    "currency"    => "gbp",
                    "card"        => $card,
                    "description" => 'Transaction ('.getGlobalValue('currency').$request['amount'].'.00)'
                )
            );

            $status = $result['paid'];
//            $transactionId = $result['id'];
            $transactionId = getAgentTransactionId();
        
            if($status == 1)
            {
                $userId = userId();
                $amount = $result['amount'] / 100;
                
                $data['amount']  = $amount;
                $data['action']  = 'Payment By Stripe';
                $data['user_id'] = $userId;
                
                if($cardId == 0)
                {
                    $request['user_id'] = $userId;
                    $requestData = $request->all();

                    \App\UserCreditCard::create($requestData);
                }
            
                UserBalance::create($data);

                $where['id'] = $userId;

                DB::table('users')->where($where)->increment('balance', $amount);
            }
            
            $response = json_encode($result);
        } 
        catch(\Exception $e)
        {
            $code    = $e->getCode();
            $message = $e->getMessage();
            $type    = $e->getErrorType();

            $response = 'Error Code: '.$code.' Error Message: '.$message.' Error Type: '.$type;
        }

        $data_1['transaction_id'] = $transactionId;
        $data_1['response']       = $response;
        $data_1['payment_method'] = 'Stripe';
        $data_1['user_id']        = userId();

        PaymentMethodResponse::create($data_1);    
        
        if($status == 1)
        {
            Session::flash('transaction_id', $transactionId);
        }else
        {
            Session::flash('error_message', $message);
        }
                
        return response()->json(['response' => 'success']);
    }
    
    public function paypalStore(Request $request)
    {
        $userId = $request['item_number'];
        
        $data_1['transaction_id'] = getAgentTransactionId();
        $data_1['response'] = $request;
        $data_1['payment_method'] = 'Paypal';
        $data_1['user_id'] = $userId;

        PaymentMethodResponse::create($data_1);
        
        if($request['payment_status'] == 'Completed')
        {
            $amount = $request['payment_gross'];
            
            $deduct = ($amount * 5) / 100;
            $updatedAmount = $amount - $deduct;
            
//            $data['transaction_id'] = $request['txn_id'];
            $data['amount']         = $updatedAmount;
            $data['action']         = 'Payment By Paypal';
            $data['user_id']        = $userId;

            UserBalance::create($data);

            $where['id'] = $userId;

            DB::table('users')->where($where)->increment('balance', $updatedAmount);
        }
    }    
    
    public function paypalThanks(Request $request)
    {
        $date       = '';
        $amount     = 0;
        $charges    = '';
        $total      = 0;
        $message    = $request['payment_status'];
        
        if($request['payment_status'] == 'Completed')
        {
            $date       = date('d/m/Y H:i:s', strtotime($request['payment_date']));
            $amount     = $request['payment_gross'];
            $charges    = '5%';
            
            $deduct = ($amount * 5) / 100;
            $total  = $amount - $deduct;
        }
        
        return view('transactions.instant_credit_paypal_receipt', compact('date', 'amount', 'charges', 'total', 'message'));
    }
/*    
    public function printTopupreceipt(Request $request)
    {
        $where['id'] = $request['topup_id'];
        $where['user_id'] = userId();
        
        $topup = \App\Topup::where($where)->first();

        return view('transactions.print_receipt', compact('topup'));
    }
*/    
    public function terms()
    {
        return view('terms');
    }    
    
    public function authenticate(Request $request)
    {
        $authentication = \App::make('authenticator');

        $data['email'] = $request['email'];
        $data['password'] = $request['password'];

        $result = $authentication->authenticate($data, false);
            
        if($result != '')
        {
            return response()->json(['response' => 'error']);
        }else
        {
            return response()->json(['response' => 'success']);
        }
    }
    
    
/*    
    public function paypalcancel(Request $request)
    {
        Session::flash('payment_fail', 'Payment Cancel');
        return redirect('/');
    }*/
}
