<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\SimProduct;
use Illuminate\Http\Request;
use Session;

class SimProductsController extends Controller
{
//    public function __construct(Request $request)
//    {
//        if(!$request->ajax())
//        {
//            redirect('/admin')->send();
//        }
//    }
  //for list in table
    public function index()
    {
        $sim_products = SimProduct::get();

        return view('sim_products.index', compact('sim_products'));
    }
    //for create sim product
    public function create()
    {
        return view('sim_products.create');
    }

    //for save sim product
    public function store(Request $request)
    {
        $this->validate($request, [
			'name' => 'required|alpha_dash_space|max:30|unique:sim_products,name,NULL,id,network_id,'.$request['network_id'],
            'network_id'=>'required'
		]);
        $request['user_id'] = userId();
        $requestData = $request->all();

        SimProduct::create($requestData);

        Session::flash('flash_message', 'SIM Product added!');

        return response()->json(['response' => 'success']);
        //return redirect('sim_products');
    }
    //for edit sim product
    public function edit($id)
    {
        $sim_product = SimProduct::findOrFail($id);

        return view('sim_products.edit', compact('sim_product'));
    }

    //for update sim product
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'name' => 'required|alpha_dash_space|max:30|unique:sim_products,name,'.$id.',id,network_id,'.$request['network_id'],
            'network_id'=>'required'
        ]);
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $sim_product = SimProduct::findOrFail($id);
        $sim_product->update($requestData);

        Session::flash('flash_message', 'SIM Product updated!');

        return response()->json(['response' => 'success']);
    }
}
