<?php

namespace App\Http\Controllers;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\SimInformation;
use App\SimInformationData;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Session, Datatables;

class SimReportsController extends Controller
{
    public function currentDateTime(){
        $now = Carbon::now();
        return $now;
    }
    public function index()
    {
        $check = $where['user_id'] = userId();

            $now = Carbon::now();
            $where['created_at']  = $now;
        $products = SimInformationData::select(\DB::raw('sim_information_data.created_at,agent_id, count(*) AS total_allotted'))->groupBy(\DB::raw('EXTRACT(MONTH FROM created_at)'))->where(function ($query)
                {

                    if(userGroup() == 'agent')
                    {
                        $query->where('agent_id', userId());
                    }
                })->get();
        $count_sim_allotted = SimInformationData::whereNotNull('sale_agent_id')->groupBy(\DB::raw('EXTRACT(MONTH FROM created_at)'))->count();


            return view('sim_reports.index',compact('products','check','count_sim_allotted'));
    }

    public function reports(Request $request)
    {
        $monthYear = $request['month_year'];
        if($monthYear != '')
        {
            $month = explode('|', $monthYear);
            $m = $month[0];
            $y = $month[1];
        }else
        {
            $m = $request['m'];
            $y = $request['y'];
            $monthYear = $m.'|'.$y;
        }

        $products = SimInformationData::whereNotNull('user_id')->groupBy(\DB::raw('EXTRACT(MONTH FROM created_at)'))->get();
        $numDays = cal_days_in_month(CAL_GREGORIAN, $m , $y);
        $start_date = $y . "-" . $m . "-" . 1 .' '.'00:00:00';
        $end_date = $y . "-" . $m . "-" . $numDays .' '.'23:59:59';

        $check = $where['user_id'] = userId();

        $simInformationData = SimInformation::select(\DB::raw('network_id, count(*) AS total_network'))->where(function($query) use ($start_date, $end_date)
        {
            $query->whereBetween('sim_information_data.created_at',array($start_date, $end_date))->whereNotNull('agent_id');
            if(userGroup() == 'agent')
            {
                $query->where('agent_id', userId());
            }
        })->join('sim_information_data' , 'sim_informations.id' ,'sim_information_data.sim_information_id')
            ->groupBy('network_id')->get();

        $simAssaingned = SimInformation::select(\DB::raw('network_id,product_id, count(*) AS total_network'))->where(function($query) use ($start_date, $end_date)
            {
                $query->whereBetween('sim_information_data.created_at',array($start_date, $end_date))->whereNotNull('agent_id');
                if(userGroup() == 'agent')
                {
                    $query->where('agent_id', userId());
                }
            })->join('sim_information_data' , 'sim_informations.id' ,'sim_information_data.sim_information_id')
                ->groupBy('network_id','product_id')->get();

        $simAssaingnedCount = SimInformation::select(\DB::raw('network_id,product_id, count(*) AS total_network'))->whereBetween('sim_information_data.created_at',array($start_date, $end_date))
                                                        ->whereNotNull('agent_id')
                                                        ->join('sim_information_data' , 'sim_informations.id' ,'sim_information_data.sim_information_id')->groupBy('network_id','product_id')
                                                        ->count();
        $simActiveCount = SimInformation::select(\DB::raw('network_id,product_id, count(*) AS total_network'))->whereBetween('sim_information_data.created_at',array($start_date, $end_date))
                                                            ->whereNotNull('agent_id')
                                                            ->join('sim_information_data' , 'sim_informations.id' ,'sim_information_data.sim_information_id')->groupBy('network_id','product_id')
                                                            ->count();


        return view('sim_reports.report',compact('simInformationData','simAssaingned','simAssaingnedCount','products', 'monthYear','check','simActiveCount'));
        }
}

