<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MnrService extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'mnr_services';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'amount',
        'amount_type',
        'category_id',
        'url',
        'sort_order',
        'type',
        'status',
        'user_id'
    ];
    
    public function category()
    {
        return $this->belongsTo('App\Category');
    }
}
