<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MobileProduct extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'mobile_products';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['name', 'brand_id', 'new_quantity', 'refurb_quantity', 'price', 'image_name', 'status', 'user_id'];

    public function brand()
    {
        return $this->belongsTo('App\Brand');
    }
}
