<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ParcelInformation extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'parcel_informations';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'parcel_contents',
        'estimated_value',
        'bundle_data',
        'collection_id',
        'delivery_id',
        'collection_table_id',
//        'delivery_table_id',
//        'CollectionAddress3',
//        'CollectionTown',
//        'CollectionCounty',
//        'CollectionPostcode',
//        'CollectionTelephone',
//        'CollectionCountry',
//        'DeliveryName',
//        'DeliveryCompany',
//        'DeliveryAddress1',
//        'DeliveryAddress2',
//        'DeliveryAddress3',
//        'DeliveryTown',
//        'DeliveryCounty',
//        'DeliveryPostcode',
//        'DeliveryTelephone',
//        'DeliveryCountry',
//        'QuoteID',
//        'ItemID',
//        'CollectionDate',
//        'SubTotal',
//        'VatTotal',
//        'TotalPrice',
        'transaction_id',
        'type',
        'user_id'
    ];
    
    public function cargo()
    {
        return $this->hasOne('App\Cargo');
    }
    
    public function courierService()
    {
        return $this->hasOne('App\CourierService');
    }
    
    public function collectionAddress()
    {
        return $this->belongsTo('App\Address', 'collection_id', 'id');
    }
    
    public function deliveryAddress()
    {
        return $this->belongsTo('App\Address', 'delivery_id', 'id');
    }
}
