<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'products';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['name', 'category_id', 'image_name', 'status', 'description', 'user_id'];

    public function amounts()
    {
        return $this->belongsToMany('App\Amount')->withPivot('cost_price', 'agent_price')->orderBy('amount', 'ASC');
    }
    
    public function category()
    {
        return $this->belongsTo('App\Category');
    }
}
