<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Validator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        /**
        * Validate that an attribute contains only alpha-numeric characters, dashes, underscores and spaces.
        *
        * @param  string  $attribute
        * @param  mixed   $value
        * @return bool
        */
        
        Validator::extend('alphaDashSpace', function($attribute, $value, $parameters, $validator) {
            
            if (! is_string($value) && ! is_numeric($value)) 
            {
                return false;
            }

            return preg_match('/^[\pL\pM\pN\s_-]+$/u', $value);
        });
        
        /**
        * Validate that an attribute contains only alpha-numeric characters, dashes.
        *
        * @param  string  $attribute
        * @param  mixed   $value
        * @return bool
        */
        
        Validator::extend('alphaDash2', function($attribute, $value, $parameters, $validator) {
            
            if (! is_string($value) && ! is_numeric($value)) 
            {
                return false;
            }

            return preg_match('/^[\pL\pM][\pL\pM\pN-]+$/u', $value);
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
