<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SimInformationData extends Model
{
    protected $table = 'sim_information_data';

    /**
     * The database primary key value.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['sim_information_id', 'ssn', 'cli', 'expired_date', 'sale_agent_id', 'sale_agent_allotment_date', 'agent_id', 'agent_allotment_date', 'user_id'];

    public function simInformation()
    {
        return $this->belongsTo('App\SimInformation', 'created_at');
    }
    
    public function userProfile()
    {
        return $this->belongsTo('LaravelAcl\Authentication\Models\UserProfile', 'agent_id', 'user_id');
    }
}
