<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class UnlockingMobile extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'unlocking_mobiles';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['service_id', 'imei_number', 'price', 'send_sms', 'status', 'comments', 'transaction_id', 'user_id'];
    
    public function user()
    {
        return $this->belongsTo('App\User');
    }
    
    public function userProfile()
    {
        return $this->belongsTo('LaravelAcl\Authentication\Models\UserProfile', 'user_id');
    }
    
    public function service()
    {
        return $this->belongsTo('App\Service');
    }
    
    function getCreatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('d/m/Y H:i:s');
    }
}
