<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConfigsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('configs', function(Blueprint $table) {
            $table->increments('id');
            $table->string('config_key', 30);
            $table->string('config_value');
            $table->string('possible_values')->nullable();
            $table->string('type', 10);
            $table->boolean('status')->default(1);
            $table->text('description');
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            // foreign keys
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('configs');
    }
}
