<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankAccountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_accounts', function(Blueprint $table) {
            $table->increments('id');
            $table->string('account_name', 30);
            $table->string('account_number', 30);
            $table->string('sort_code', 30);
            $table->integer('bank_id')->unsigned();
            $table->boolean('status')->default(1);
            $table->text('comments')->nullable();
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->foreign('bank_id')
                ->references('id')->on('banks')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('bank_accounts');
    }
}
