<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('banking', function(Blueprint $table) {
            $table->increments('id');
            $table->date('date');
            $table->integer('bank_id')->unsigned();
            $table->decimal('amount', 10, 2);
            $table->string('payment_ref', 100);
            $table->boolean('approved')->default(0);
            $table->integer('transaction_id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->foreign('bank_id')
                ->references('id')->on('banks')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('banking');
    }
}
