<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAmountProductTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('amount_product', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('amount_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->decimal('cost_price', 10, 2)->default(0.00);
            $table->decimal('agent_price', 10, 2)->default(0.00);
            
            $table->foreign('amount_id')
                ->references('id')->on('amounts')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('product_id')
                ->references('id')->on('products')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('amount_product');
    }
}
