<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function(Blueprint $table) {
            $table->increments('id');
            $table->string('email')->nullable();
            $table->string('title', 5);
            $table->string('first_name', 50);
            $table->string('last_name', 50);
            $table->date('dob')->nullable();
//            $table->string('address_line_1')->nullable();
//            $table->string('town', 50)->nullable();
//            $table->string('county', 50)->nullable();
//            $table->string('post_code', 20)->nullable();
//            $table->string('phone_no', 20);
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('customers');
    }
}