<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomFieldsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('custom_fields', function(Blueprint $table) {
            $table->increments('id');
            $table->string('name', 30);
            $table->integer('module_id')->unsigned();
            $table->integer('field_type_id')->unsigned();
            $table->text('field_values')->nullable();
            $table->boolean('after_amount')->default(0);
            $table->integer('sort_order')->unsigned()->default(0);
            $table->boolean('modal')->default(1);
            $table->boolean('global')->default(0);
            $table->boolean('status')->default(1);
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->foreign('module_id')
                ->references('id')->on('modules')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('field_type_id')
                ->references('id')->on('custom_field_types')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('custom_fields');
    }
}