<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNetworkCommissionSchemeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('network_commission_scheme', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('network_id')->unsigned();
            $table->integer('network_commission_id')->unsigned();
            $table->tinyInteger('topup_level')->unsigned();
            $table->decimal('commission', 10, 2);
            $table->integer('sort_order')->unsigned()->default(0);
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->foreign('network_id')
                ->references('id')->on('networks')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('network_commission_id')
                ->references('id')->on('network_commission')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('network_commission_scheme');
    }
}
