var mnreHub = function () {
    
    var amount = function() {
        
	var return_url = base_url +'/amounts';
	var form       = $('#amount');
	
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                amount: {
                    required: true,
                    number: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if(element.closest('.input-group').length > 0)
                {
                    error.insertAfter(element.closest('.input-group'));
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
	});
    };
    
    var api = function() {
        
	var return_url = base_url +'/apis';
	var form       = $('#api');

	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                user_name: {
                    required: true,
                    alphanumericdash: true,
                    maxlength: 30
                },
                api: {
                    required: true,
                    alphanumericdash: true
                },
                url: {
                    required: true,
                    url: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var bank = function() {
        
	var return_url = base_url +'/banks';
	var form       = $('#bank');

	form.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: '',  // validate all fields including form hidden input
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 30
                },
                image: {
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 200000 // Byte and it will be 200 KB
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) { 
                if(element.attr('id') == 'image'){
                    error.insertAfter('.fileinput');
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
	});
    };
    
    var bankAccount = function() {
        
	var return_url = base_url +'/bank_accounts';
	var form       = $('#bank_account');

	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                account_name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 30
                },
                account_number: {
                    required: true,
                    maxlength: 18,
                    minlength: 10,
                    digits: true
                },
                sort_code: {
                    required: true,
                    maxlength: 3,
                    minlength: 6,
                    digits: true
                },
                bank_id: {
                    required: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var brand = function() {
        
	var return_url = base_url +'/brands';
	var form       = $('#brand');

	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 30
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var cargoService = function() {
        
	var return_url = base_url +'/cargo_services?cargo_type='+$('input[name=cargo_type]').val();
	var form       = $('#cargo_service');
	
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 30
                },
                image: {
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 200000
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if(element.attr('id') == 'image'){
                    error.insertAfter('.fileinput');
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
	});
    };
    
    var cargoServiceRate = function() {
        
	var return_url = base_url +'/cargo_service_rates?cargo_type='+$('input[name=cargo_type]').val();
	var form       = $('#cargo_service_rate');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                collection_country_id: {
                    required: true
                },
                delivery_country_id: {
                    required: true
                },
                cargo_service_id: {
                    required: true
                },
                rate: {
                    required: true,
                    number: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) {
                if(element.closest('.input-group').length > 0)
                {
                    error.insertAfter(element.closest('.input-group'));
                }else if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var category = function() {
        
	var return_url = base_url +'/categories?type='+$('input[name=type]').val();
	var form       = $('#category');
	
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 100
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var companyProfile = function() {

        var return_url = base_url +'/admin/users/profile/self';
        var form       = $('#company_profile');

        form.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: '',  // validate all fields including form hidden input
            rules: {
                image: {
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 200000 // Byte and it will be 200 KB
                }
            },

            invalidHandler: function (event, validator) {
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) {
                if(element.attr('id') == 'image'){
                    error.insertAfter('.fileinput');
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error');
            },

            unhighlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-error');
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
        });
    };
    
    var config = function() {
        
	var return_url = base_url +'/configs';
        var form       = $('#config');
       
        form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                config_key: {
                    required: true,
                    alphanumeric: true,
                    maxlength: 30
                },
                config_value: {
                    required: true,
                    maxlength: 255
                },
                type: {
                    required: true,
                    lettersonly: true,
                    maxlength: 30
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var mnrService = function() {
        
	var return_url = base_url +'/mnr_services?type='+$('input[name=type]').val();
	var form       = $('#mnr_service');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 255
                },
                category_id: {
                    required: true
                },
                amount: {
                    required: true,
                    number: true,
                    maxlength: 8
                },
                url: {
                    required: true,
                    url: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
	});
    };
    
    var mobileProduct = function() {
        
	var return_url = base_url +'/mobile_products';
	var form       = $('#mobile_product');

	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                brand_id: {
                    required: true
                },
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 100
                },
                new_quantity: {
                    required: true,
                    digits: true,
                    maxlength: 5
                },
                refurb_quantity: {
                    required: true,
                    digits: true,
                    maxlength: 5
                },
                price: {
                    required: true,
                    number: true
                },
                image: {
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 200000
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if(element.attr('id') == 'image'){
                    error.insertAfter('.fileinput');
                }else if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
	});
    };
    
    var network = function() {
        
	var return_url = base_url +'/networks';
	var form       = $('#network');
	
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 30
                },
                image: {
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 200000
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if(element.attr('id') == 'image'){
                    error.insertAfter('.fileinput');
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
	});
    };
    
    var networkCommission = function() {
        
	var return_url = base_url +'/network_commission';
	var form       = $('#network_commission');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 30
                },
                topup_level: {
                    required: true,
                    digits: true,
                    maxlength: 5
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) {
                if(element.closest('.input-group').length > 0)
                {
                    error.insertAfter(element.closest('.input-group'));
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var networkCommissionScheme = function() {
        
	var return_url = base_url +'/network_commission/network_commission_scheme?network_commission_id='+$('input[name=network_commission_id]').val();
	var form       = $('#network_commission_scheme');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                network_id: {
                    required: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) {
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var importNetworkIncentive = function() {
        
	var return_url = base_url +'/network_commission/network_incentive_list';
        var form       = $('#import_network_incentive');
       
        form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                file: {
                    required: true,
                    extension: 'csv',
                    filesize: 400000 // Byte and it will be 400 KB
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) { 
                if(element.attr('name') == 'file'){
                    error.insertAfter('.input-large');
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
	});
    };
    
    var product = function() {
        
	var return_url = base_url +'/products';
	var form       = $('#product');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 30
                },
                category_id: {
                    required: true
                },
                image: {
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 200000
                },
                'amount[]': {
                    required: true
                },
                'cost_price[]': {
                    required: true
                },
                'agent_price[]': {
                    required: true
                },
                description: {
                    required: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if(element.closest('.input-group').length > 0)
                {
                    error.insertAfter(element.closest('.input-group'));
                }else if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
	});
    };
    //Sim Mangement (AM)
    var simProducts = function() {

        var return_url = base_url +'/sim_products';
        var form       = $('#sim_products');
      
        form.validate({
            errorElement: 'span',
            errorClass: 'help-block help-block-error',
            focusInvalid: false,
            ignore: '',
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 30
                },
                network_id: {
                    required: true
                }
            },

            invalidHandler: function (event, validator) {
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) {
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error');
            },

            unhighlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-error');
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
        });
    };
    
    //Sim Information (AM)
    var simInformation = function() {

        var return_url = base_url +'/sim_informations';
        var form       = $('#sim_informations');
     
        form.validate({
            errorElement: 'span',
            errorClass: 'help-block help-block-error',
            focusInvalid: false,
            ignore: '',
            rules: {
                network_id: {
                    required: true
                },
                product_id: {
                    required: true
                },
                expired_date: {
                    required: true
                },
                'ssn[]': {
                    required: true,
                    digits: true,
                    maxlength: 25
                },
                'cli[]': {
                    digits: true,
                    maxlength: 25
                }
            },

            invalidHandler: function (event, validator) {
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) {
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error');
            },

            unhighlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-error');
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
        });
    };
    //Sim Allotment (AM)
    var saleAgentSimAllotment = function() {

        var return_url = base_url +'/sale_agent_sim_allotment';
        var form       = $('#sale_agent_sim_allotment');

        form.validate({
            errorElement: 'span',
            errorClass: 'help-block help-block-error',
            focusInvalid: false,
            ignore: '',
            rules: {
                user_id: {
                    required: true
                },
                'ssn[]': {
                    exist: true
                }
            },

            invalidHandler: function (event, validator) {
                toastr_call(2, '');
            },
/*
            errorPlacement: function (error, element) {
                if (element.hasClass('select2') || element.hasClass('amount')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },
*/
            highlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error');
            },

            unhighlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-error');
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
        });
    };

    //Sim Allotment Agent (AM)
    var agentSimAllotment = function() {

        var return_url = base_url +'/agent_sim_allotment';
        var form       = $('#agent_sim_allotment');
        
        form.validate({
            errorElement: 'span',
            errorClass: 'help-block help-block-error',
            focusInvalid: false,
            ignore: '',
            rules: {
                user_id: {
                    required: true
                },
                'ssn[]': {
                    exist: true
                }
            },

            invalidHandler: function (event, validator) {
                toastr_call(2, '');
            },
/*
            errorPlacement: function (error, element) {
                if (element.hasClass('select2') || element.hasClass('amount')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },
*/
            highlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error');
            },

            unhighlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-error');
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
        });
    };
    
    var pinNumber = function() {
        
	var return_url = base_url +'/pin_numbers';
	var form       = $('#pin_number');

	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                category_id: {
                    required: true
                },
                product_id: {
                    required: true
                },
                amount: {
                    required: true
                },
                sale_price: {
                    required: true,
                    number: true
                },
                expired_date: {
                    required: true
                },
                'pin_number[]': {
                    required: true,
                    digits: true,
                    maxlength: 20
                },
                'serial_number[]': {
                    required: true,
                    digits: true,
                    maxlength: 20
                },
                pin_number: {
                    required: true,
                    digits: true,
                    maxlength: 20
                },
                serial_number: {
                    required: true,
                    digits: true,
                    maxlength: 20
                }                
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var service = function() {
        
	var return_url = base_url +'/services';
	var form       = $('#service');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                name: {
                    required: true,
//                    alphanumdashspace: true,
                    maxlength: 255
                },
                category_id: {
                    required: true
                },
                price: {
                    required: true,
                    number: true
                },
                image: {
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 200000
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if(element.attr('id') == 'image'){
                    error.insertAfter('.fileinput');
                }else if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.closest('.input-group').length > 0)
                {
                    error.insertAfter(element.closest('.input-group'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
	});
    };
    
    var updateServicePrice = function() {
        
	var return_url = base_url +'/services';
	var form       = $('#update_price');
   
	form.validate({
            
            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var unclockingMobileStatus = function() {
        
	var form = $('#unlocking_mobile_status');
	
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                id: {
                    required: true
                },
                status: {
                    required: true
                },
                response: {
                    required: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                var return_url;
                var list = $('input[name=list]').val();
                
                if(list == 1)
                {
                    return_url = base_url+'/reports/unlocking_mobile_list?page=1';
                }else if(list == 2)
                {
                    return_url = base_url+'/reports/unlocking_mobile_status?page=1';
                }else
                {
                    return_url = base_url+'/admin/dashboard';
                }
                
                ajax_call($(form), return_url);
            }
	});
    };
    
    var updateAvatar = function() {
        
	var form = $('#update_avatar');
	
	form.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: '',  // validate all fields including form hidden input
            rules: {
                avatar: {
                    required: true,
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 400000 // Byte and it will be 400 KB
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) { 
                if(element.attr('name') == 'avatar'){
                    error.insertAfter('.fileinput');
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload_acl($(form));
            }
	});
    };
    
    var updatePassword = function() {
        
	var form = $('#update_password');
	
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                password: {
                    required: true,
                    minlength: 6
                },
                password_confirmation: {
                    required: true,
                    minlength: 6,
                    equalTo: '#password'
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_acl2($(form));
            }
	});
    };
    
    var user = function() {
        
	var form = $('#user');
	 
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                email: {
                    required: true,
                    email: true
                },
                password: {
                    minlength: 6
                },
                password_confirmation: {
                    minlength: 6,
                    equalTo: '#password'
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_acl($(form));
            }
	});
    };
    
    var userProfile = function() {
        
	var form = $('#user_profile');
        
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                title: {
                    required: true,
                    lettersonly: true,
                    maxlength: 5
                },
                first_name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                last_name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                mobile_no : {
                    required: true,
                    mobileUK: true
                },
                business_no : {
                    phoneUK: true
                },   
                company: {
                    required: true,
                    maxlength: 50
                },
                vat: {
                    maxlength: 20
                },
                town: {
                    maxlength: 50
                },
                county: {
                    maxlength: 50
                },
                zip: {
                    postcodeUK: true
                },
                address: {
                    required: true
                }                    
            },
            
            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                var return_url;
                var user_profile = $('input[name=user_profile]').val();
                
                if(user_profile == 1)
                {
                    return_url = base_url +'/admin/users/profile/edit?user_id='+$('input[name=user_id]').val();
                }else
                {
                    return_url = base_url +'/admin/users/profile/self';
                }
                
                ajax_call($(form), return_url); 
            }
	});
    };
    
    var table = function() {
        
        var table = $('.datatable');

        table.dataTable({

            // Internationalisation. For more info refer to http://datatables.net/manual/i18n
            'language': {
                'aria': {
                    'sortAscending': ': activate to sort column ascending',
                    'sortDescending': ': activate to sort column descending'
                },
                'emptyTable': 'No data available in table',
                'info': 'Showing _START_ to _END_ of _TOTAL_ records',
                'infoEmpty': 'No records found',
                'infoFiltered': '(filtered1 from _MAX_ total records)',
                'lengthMenu': 'Show:&nbsp; _MENU_',
                'search': 'Search:',
                'zeroRecords': 'No matching records found',
                'paginate': {
                    'previous':'Prev',
                    'next': 'Next',
                    'last': 'Last',
                    'first': 'First'
                }
            },

            // Uncomment below line('dom' parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
            // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js). 
            // So when dropdowns used the scrollable div should be removed. 
            //'dom': '<'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r>t<'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>',

            'bStateSave': true, // save datatable state(pagination, sort, etc) in cookie.
            'pagingType': 'bootstrap_extended',
/*
            'lengthMenu': [
                [5, 15, 20, -1],
                [5, 15, 20, 'All'] // change per page values here
            ],*/
            // set the initial value
            'pageLength': 25,
            'columnDefs': [{  // set default column settings
                'orderable': false,
                'targets': [-1]
            }, {
                'searchable': false,
                'targets': [-1]
            }]
        });
    };
    
    var scripts = function() {
 
//-----------------------------------Select2------------------------------------
        
        $.fn.select2.defaults.set('theme', 'bootstrap');

        $('.select2, .select2-multiple').select2({
            width: null,
            minimumResultsForSearch: 7
        }).on('change', function() {
            $(this).valid();
        });

//-------------------------------WYSIHTML5 Editor-------------------------------
/*
        if (!jQuery().wysihtml5) {
            return;
        }

        if ($('.wysihtml5').size() > 0) {
            $('.wysihtml5').wysihtml5({
                "stylesheets": ["packages/metronic/global/plugins/bootstrap-wysihtml5/wysiwyg-color.css"]
            });
        }
*/

//------------------------------Summernote Editor-------------------------------

        $('.summernote').summernote({height: 300});
        
//---------------------------------Date Picker----------------------------------

        $('.date-picker').datepicker({
            format: 'dd/mm/yyyy',                
            rtl: App.isRTL(),
            orientation: "left",
            autoclose: true
        }).on('changeDate', function() {
            $(this).valid();
        });
        
//-------------------------------Touchspin Editor-------------------------------

        $(".digits").TouchSpin({
            min: 0,
            max: 1000000,
            step: 1,
            boostat: 5,
            maxboostedstep: 10
        });
        
        $(".touchspin").TouchSpin({
            min: 0,
            max: 1000000,
            step: 0.01,
            decimals: 2,
            boostat: 5,
            maxboostedstep: 10
        });
        
//------------------------------Validation Methods------------------------------
        
        $.validator.addMethod('alphanumdashspace', function(value, element) {
//                return this.optional(element) || /^[\a-zA-Z][\a-zA-Z0-9-_\s]+$/i.test(value);
            return this.optional(element) || /^[\a-zA-Z0-9-_\s]+$/i.test(value);
        }, 'Letters, numbers, dashes and space only please');
        
        $.validator.addMethod('alphanumericdash', function(value, element) {
                return this.optional(element) || /^[\a-zA-Z][\a-zA-Z0-9-]+$/i.test(value);
        }, 'Letters, numbers, dashes only please');
        
        $.validator.addMethod('filesize', function (value, element, param) {
            return this.optional(element) || (element.files[0].size <= param)
        }, 'File size must be less than {0}');

        $.validator.addMethod('exist', function(value, element) {
            var result = 0;
            var type = element.id.split('_');
            
            if(value != '')
            {
                $.ajax({
                    url: base_url+'/sim_informations/'+type[0]+'/'+value+'/get_ssn_info',
                    type: 'get',
                    dataType: 'html',
                    async: false,
                    success: function(data) {
                        result = data;
                    }
                });
            }
            
            if(result == 0)
                return false;
            else
                return true;

        }, 'CLI or SSN not Exist!');
    };
    
    return {
 
        init: function () {      
            amount();
            api();
            bank();
            bankAccount();
            brand();
            cargoService();
            cargoServiceRate();
            category();
            companyProfile();
            config();
            mnrService();
            mobileProduct();
            network();
            networkCommission();
            networkCommissionScheme();
            importNetworkIncentive();
            product();
            simProducts();
            simInformation();
            saleAgentSimAllotment();
            agentSimAllotment();
            pinNumber();
            service();
            updateServicePrice();
            unclockingMobileStatus();
            updateAvatar();
            updatePassword();
            user();
            userProfile();
            table();
            scripts();
        }
    };
}();

function lookup(val)
{
    App.scrollTop();
    var pageContentBody = $('.page-fixed-main-content');
    App.startPageLoading();

    $.ajax({
        url  : val.attr('action'),
        type : val.attr('method'),
        data : val.serialize(),
        success: function(res){
            App.stopPageLoading();
            pageContentBody.html(res);
            App.initAjax(); // initialize core stuff
        },
        statusCode: {
            500:function() {
                pageContentBody.html(error_500);
            },
            401:function() {
                pageContentBody.html(error_401);
            },
            404:function() {
                pageContentBody.html(error_404);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            App.stopPageLoading();
            pageContentBody.html(error_500);
        }
    });
}

function ajax_call(form, return_url)  
{
    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');
    
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: form.serialize(),
        dataType: 'json',
        success: function(data)
        {
            $('.modal-backdrop').fadeOut();
            if(data.response == 'success')
            {
                return_page(return_url);
            }else
            {
                toastr_call(2, data.message);
            }
            btn.button('reset');
        },
        error : function(data) 
        { 
            var status = data.status;
            if(status == 401)
            {
                toastr_call(2, error_401_2);
            }else if(status == 404)
            {
                toastr_call(2, error_404_2);
            }else if(status == 422)
            {
                var response = '';
                var errors = $.parseJSON(data.responseText);

                $.each(errors, function(index, value) {
                    response += value + '<br>'; 
                });
                
                toastr_call(2, response);
            }else
            {
                toastr_call(2, error_500_2);
            }
            
            $('.modal-backdrop').fadeOut();
            btn.button('reset');
        }
    });
    return false;
}

function ajax_call2(data, url, return_url)
{
    $.ajax({
        type: 'POST',
        url: url,
        data: data,
        dataType: 'json',
        success: function(data)
        {
            $('.modal-backdrop').fadeOut();
            if(data.response == 'success')
            {
                return_page(return_url);
            }else
            {
                $('.modal-backdrop').fadeOut();
                toastr_call(2, data.message);
            }
        },
        error : function(data) 
        {  
            var status = data.status;
            if(status == 401)
            {
                toastr_call(2, error_401_2);
            }else if(status == 404)
            {
                toastr_call(2, error_404_2);
            }else
            {
                toastr_call(2, error_500_2);
            }
        }
    });
}

function ajax_call_file_upload(form, return_url)  
{
    var formData = new FormData(form[0]);
    
    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');
    
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: formData,
        dataType: 'json',
        async: false,
        cache: false,
        contentType: false,
        processData: false,
        success: function(data)
        {
            $('.modal-backdrop').fadeOut();
            if(data.response == 'success')
            {
                return_page(return_url);
            }else
            {
                toastr_call(2, data.message);
            }
            btn.button('reset');
        },
        error : function(data) 
        { 
            var status = data.status;
            if(status == 401)
            {
                toastr_call(2, error_401_2);
            }else if(status == 404)
            {
                toastr_call(2, error_404_2);
            }else if(status == 422)
            {
                var response = '';
                var errors = $.parseJSON(data.responseText);

                $.each(errors, function(index, value) {
                    response += value + '<br>'; 
                });
                
                toastr_call(2, response);
            }else
            {
                toastr_call(2, error_500_2);
            }
            $('.modal-backdrop').fadeOut();
            btn.button('reset');
        }
    });
    return false;
}

function ajax_call_acl(form)  
{
    App.scrollTop();
    var pageContentBody = $('.page-fixed-main-content');
    App.startPageLoading();
    
    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');
    
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: form.serialize(),
        dataType: 'html',
        success: function(data)
        {
            App.stopPageLoading();
            pageContentBody.html(data);
            App.initAjax(); // initialize core stuff
        },
        error : function() 
        { 
            toastr_call(2, error_500_2);
            btn.button('reset');
        }
    });
    return false;
}

function ajax_call_acl2(form)  
{
    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');
    
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: form.serialize(),
        dataType: 'html',
        async: false,
        success: function()
        {
            form.find('input[type=password]').val('');
            toastr_call(1, 'Password is updated successfully');
            btn.button('reset');
        },
        error : function() 
        { 
            toastr_call(2, error_500_2);
            btn.button('reset');
        }
    });
    return false;
}

function ajax_call_file_upload_acl(form)  
{
    var formData = new FormData(form[0]);
    
    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');
    
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: formData,
        dataType: 'html',
        async: false,
        cache: false,
        contentType: false,
        processData: false,
        success: function()
        {
            window.location.href = base_url+'/admin';
        },
        error : function() 
        { 
            toastr_call(2, error_500_2);
            btn.button('reset');
        }
    });
    return false;
}

function delete_record_acl(url)
{
    bootbox.confirm('Are you sure you want to delete the record?', function(result) 
    {
        if(result == true)
        {
            App.scrollTop();
            var pageContentBody = $('.page-fixed-main-content');
            App.startPageLoading();
    
            $.ajax({
                type: 'GET',
                url: url,
                dataType: 'html',
                success: function(data)
                {
                    App.stopPageLoading();
                    pageContentBody.html(data);
                    App.initAjax(); // initialize core stuff
                },
                error : function() 
                { 
                    toastr_call(2, error_500_2);
                }
            });
        }
    });
    return false;
}

function return_page(url)
{
    App.scrollTop();
    var pageContentBody = $('.page-fixed-main-content');
    App.startPageLoading();

    $.ajax({
        type: 'GET',
        cache: false,
        url: url,
        dataType: 'html',
        success: function (res) {
            App.stopPageLoading();
            pageContentBody.html(res);
            App.initAjax(); // initialize core stuff
        },
        statusCode: {
            500:function() {
                pageContentBody.html(error_500);
            },
            401:function() { 
                pageContentBody.html(error_401); 
            },
            404:function() { 
                pageContentBody.html(error_404);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            App.stopPageLoading();
            pageContentBody.html(error_500);
        }
    });
}       

function toastr_call(message_type, message)
{
    var title;
    var shortCutFunction;
    
    if(message == '')
    {
        message = 'You have some form errors. Please check.';
    }
    
    if(message_type == 1)
    {
        shortCutFunction = 'success';
        title = 'Success!';
    }else if(message_type == 2)
    {
        shortCutFunction = 'error';
        title = 'Error!';
    }
    
    toastr.options = {
        closeButton: true,
        debug: false,
        positionClass: 'toast-bottom-right',
        onclick: null
    };

    toastr.options.showDuration = 1000;
    toastr.options.hideDuration = 1000;
    toastr.options.timeOut      = 10000;
    toastr.options.extendedTimeOut = 1000;
    toastr.options.showEasing = 'swing';
    toastr.options.hideEasing = 'linear';
    toastr.options.showMethod = 'slideDown';
    toastr.options.hideMethod = 'slideUp';

    var $toast = toastr[shortCutFunction](message, title); // Wire up an event handler to a button in the toast, if it exists
    $toastlast = $toast;
}

var interval;

function start_interval(time)
{
    interval =  setInterval(
            function()
            {
                var url = base_url+'/reports/unlocking_mobile_status?page=3';
                $.get(url, function(data) 
                {
                    $('#result').html(data);
                });                
                return false;
            }, time);
    return false;
}

function stop_interval()
{
    clearInterval(interval); 
    return false;
}