<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-settings"></i>
                    SIM Orders List
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover datatable">
                    <thead> 
                        <tr>
                            <th>Order #</th>
                            <th>Order Date</th>
                            <th>Quantity</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($simOrders as $row)
                            <tr>
                                <td>
                                    <a href="{{ url('admin/'.$row->transaction_id.'/sim_order_detail') }}" data-toggle="modal" data-target="#sim_order_detail">
                                        {{ $row->transaction_id }}
                                    </a>
                                </td>
                                <td>{{ $row->created_at }}</td>
                                <td>{{ $row->quantity }}</td>
                                <td>
                                    <a href="javascript:;" id="{{ $row->transaction_id }}" class="delivered">
                                        <button type="button" class="btn btn-warning btn-sm">Pending</button>
                                    </a>   
                                </td>
                            </tr>
                        @endforeach                    
                    </tbody>
                </table>                
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="sim_order_detail" role="basic" aria-hidden="true">
    <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//-----------------------------------Approved-----------------------------------

        $('.delivered').click(function()
        {
            var id = $(this).attr('id');
            var message = 'Are you sure you want to update this record?';
            var data = 'transaction_id='+id+'&delivered=1&_token={{ csrf_token() }}';
            var url  = base_url +'/admin/sim_delivered';
            var return_url = base_url+'/admin/sim_order_list';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call2(data, url, return_url);
                }
            });
            return false;    
        });
    });
</script>