<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    Edit Cargo Service Rate
                </div>
            </div>
            <div class="portlet-body">
                {{ Form::model($cargoServiceRate, [
                    'method' => 'PATCH',
                    'url' => ['/cargo_service_rates', $cargoServiceRate->id],
                    'id' => 'cargo_service_rate', 'class' => 'form-horizontal'
                ]) }}
                    {{ Form::hidden('cargo_type', null) }}
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Collection Country<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCountries('collection_country_id') }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Delivery Country<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCountries('delivery_country_id') }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Cargo Service<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCargoServices($cargoServiceRate->cargo_type) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Rate<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('rate', null, ['class' => 'form-control touchspin']) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-2 col-md-10">
                                {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                <button type="button" id="cancel" class="btn default">Cancel</button>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/cargo_service_rates?cargo_type={{ $cargoServiceRate->cargo_type }}';
            return_page(url);
            return false;
        });
    });
</script>