@foreach ($customFields as $row)
<?php
    $fieldId     = $row->id;
    $fieldType   = $row->field_type_id;
    $fieldValues = explode(",", $row->field_values);?>
    <div class="form-group">
        <label class="col-md-2 control-label">
            {{ $row->name }}
            {{ Form::hidden('field_id[]', $fieldId) }}
        </label>
        <div class="col-md-5">
            @if($fieldType == 1) <!--Text Box-->
                {{ Form::text('field_name[]', null, ['class' => 'form-control']) }}
            @endif

            @if($fieldType == 2) <!--Dropdown List-->
                <select name="field_name[]" class="form-control select2">
                    <option value="">Select One</option>
                    @foreach($fieldValues as $value)
                        <option value="{{ $value }}">{{ $value }}</option>
                    @endforeach          
                </select>
            @endif

            @if($fieldType == 3) <!--Textarea-->
                {{ Form::textarea('field_name[]', null, ['class' => 'form-control', 'size' => '30x3']) }}
            @endif
            
            @if($fieldType == 4) <!--Calendar-->
                {{ Form::text('field_name[]', null, ['class' => 'form-control date-picker']) }}
            @endif
            
            @if($fieldType == 5) <!--Amount-->
                {{ Form::text('field_name[]', null, ['class' => 'form-control touchspin']) }}
            @endif
        </div>                                                        
    </div>
@endforeach

<script type="text/javascript">
    jQuery(document).ready(function()
    {
        mnreHub.init();
    });
</script>