<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    <div id="portlet" class="portlet light portlet-fit">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo">
                    {{ $title }}
                </span>
            </div>
        </div>
        <div class="portlet-body">                
            <div class="form-body">
                <div class="row">
                    {{ Form::open(['url' => '/customers/customer_invoice', 'id' => 'customer_invoice', 'class' => 'form-horizontal']) }}
                        {{ Form::hidden('customer_id', $customerId, ['id' => 'customer_id']) }}
                        <div class="form-group margin-top-20">
                            <label class="col-md-2 control-label">Customer <span class="required" aria-required="true">*</span></label>
                            <div class="col-md-4">
                                {{ Form::text('customer_name', $customerName, ['id' => 'customer_name', 'readonly' => '', 'class' => 'form-control']) }}
                            </div>
                            <div class="col-md-3">
                                @if($customerId != '')
                                    <a href="#basic" data-toggle="modal" class="btn red customer_lookup">Lookup</a>                                
                                    <a href="#add_customer" data-toggle="modal" class="btn red">Add Customer</a>
                                @endif
                            </div>
                        </div>
                        @if($moduleId != '')
                            {{ Form::hidden('module_id', $moduleId) }}
                            {{ Form::hidden('table_id', $tableId) }}
                        @else
                            <div class="form-group">
                                <label class="control-label col-md-2">
                                    Module<span class="required"> * </span>
                                </label>
                                <div class="col-md-5">
                                    {{ getModules() }}
                                </div>
                            </div>
                        @endif
                        <div id="custom_data"></div>
                        <div class="form-group">
                            <label class="control-label col-md-2">
                                MNR Price<span class="required"> * </span>
                            </label>
                            <div class="col-md-5">
                                {{ Form::text('cost_price', $costPrice, ['class' => 'form-control', 'readonly' => '']) }}
                            </div>
                        </div>
                        @if($moduleId == 5 || $moduleId == 6)
                            <div class="form-group">
                                <label class="control-label col-md-2">
                                    Rate Via
                                </label>
                                <div class="col-md-5">
                                    {{ Form::select('weight', [
                                            1 => 'Weight',
                                            2 => 'Dimension'
                                        ], null, [ 
                                            'id' => 'weight', 'class' => 'form-control select2'
                                    ]) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-2">
                                    Rate
                                </label>
                                <div class="col-md-5">
                                    {{ Form::text('rate', 0.00, ['id' => 'rate', 'class' => 'form-control touchspin']) }}
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <label class="control-label col-md-2">
                                Sale Price<span class="required"> * </span>
                            </label>
                            <div class="col-md-5">
                                {{ Form::text('sale_price', null, ['class' => 'form-control touchspin']) }}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-2">
                                Description
                            </label>
                            <div class="col-md-5">
                                {{ Form::textarea('description', null, ['class' => 'form-control', 'size' => '30x3']) }}
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-2"></div>
                            <div class="col-md-5">
                                {{ Form::submit('Generate Invoice', ['class' => 'btn grey-mint']) }}
                            </div>  
                        </div>
                    {{ Form::close() }} 
                </div>
            </div>
        </div>
    </div>    
</div>
@include('customers.customer_lookup')
<div class="modal fade" id="receipt" data-backdrop="static" tabindex="-1" role="basic" aria-hidden="true">
     <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>                                            
<script type="text/javascript">
    jQuery(document).ready(function()
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//----------------------------Get Custom Fields Data----------------------------

        get_custom_data('{{ $moduleId }}');
        
        $('#module_id').change(function()
        {
            var module_id = $(this).val();
            
            get_custom_data(module_id);
        });

        function get_custom_data(module_id)
        {
            if(module_id != '')
            {
                App.blockUI({
                    target: '#portlet',
                    iconOnly: true
                });
                $.get('customers/get_custom_data?module_id='+module_id+'&modal=1', function(data) 
                {
                    $('#custom_data').html(data);
                });
                App.unblockUI('#portlet');
            }else
            {
                $('#custom_data').html('');
            }
        }
        
//-----------------------------Calculate Sale Price-----------------------------
       
        $('#weight').change(function()
        {
            get_sale_price();
        });
       
        $('#rate').keyup(function()
        {
            get_sale_price();
        });
        
        function get_sale_price()
        {
            var price = 0;
            var total_price = 0;
            var rate = $('#rate').val();
            var weight = $('#weight').val();
            
            var data = $.parseJSON('{!! $bundleData !!}');

            $.each(data, function(index, value) 
            {
               @if($moduleId == 5)
                    if(weight == 1)
                    {
                        price = value.Weight * rate;
                        total_price += price;
                    }else if(weight == 2)
                    {
                        price = ((Number(value.Dim1) * Number(value.Dim2) * Number(value.Dim3))/5000) * rate;
                        total_price += price;
                    }
               @elseif($moduleId == 6)
                    if(weight == 1)
                    {
                        price = value.weight * rate;
                        total_price += price;
                    }else if(weight == 2)
                    {
                        price = ((Number(value.dim1) * Number(value.dim2) * Number(value.dim3))/5000) * rate;
                        total_price += price;
                    }
               @endif
            });

            $('input[name=sale_price]').val(total_price.toFixed(2));
        }
        
//-----------------------------Get Customer Receipt-----------------------------

        <?php if (Session::has('customer_invoice_id')):?>
            $('#receipt').modal('show');

            $.get(base_url+"/customers/customer_receipt?customer_invoice_id={{ Session::get('customer_invoice_id') }}", function(data) 
            {
                $('#receipt .modal-content').html(data);
            });
        <?php endif;?>
    
    });
</script>