<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('customers') }}" class="ajaxify">{{ $title }}</a>
            </li>
            <li class="active">{{ $subTitle }}</li>
        </ol>
    </div>
    <div class="portlet box red">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                {{ $subTitle }}
            </div>
        </div>
        <div class="portlet-body">
            {{ Form::model($customer, [
                'method' => 'PATCH',
                'url' => ['/customers', $customer->id],
                'id' => 'customer', 'class' => 'form-horizontal'
            ]) }}
                {{ Form::hidden('address_id', $address->id) }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group margin-top-20">
                                <label class="control-label col-md-4">
                                    Title<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('title', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    First Name<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('first_name', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Last Name<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('last_name', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Phone No.<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('phone_no', $address->phone_no, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Email
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('email', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Date Of Birth
                                </label>
                                <div class="col-md-8">
                                     {{ Form::text('dob', null, ['class' => 'form-control date-picker']) }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group margin-top-20">
                                <label class="control-label col-md-4">
                                    Address Line 1
                                </label>
                                <div class="col-md-8">
                                    {{ Form::textarea('address_line_1', $address->address_line_1, ['class' => 'form-control', 'size' => '30x3']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Town
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('town', $address->town, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    County
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('county', $address->county, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Post Code
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('post_code', $address->post_code, ['class' => 'form-control']) }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-offset-2 col-md-10">
                            {{ Form::submit('Submit', ['class' => 'btn dark']) }}
                            <button type="button" id="cancel" class="btn grey-mint">Cancel</button>
                        </div>
                    </div>
                </div>
            {{ Form::close() }}
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/customers';
            return_page(url);
            return false;
        });
    });
</script>