<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
    <h4 class="modal-title">Quote Lookup</h4>
</div>
<div class="modal-body">
    <table class="table table-striped table-bordered table-hover datatable">
        <thead>
            <tr>
                <th>Quote ID</th>
                <th>Quote Date</th>
                <th>Module Name</th>
                <th>Sale Price</th>
                <th>Cost Price</th>                
                <th>Details</th>
            </tr>
        </thead>
        <tbody>
            @if($customerInvoice->count() > 0)
                @foreach($customerInvoice as $row)
                    <tr>
                        <td><a href="javascript:;" class="quote_details" id="{{ $row->id.'|'.$row->created_at }}">{{ $row->id }}</a></td>
                        <td>{{ $row->created_at }}</td>
                        <td>{{ $row->module->name }}</td>
                        <td>{{ $row->sale_price }}</td>
                        <td>{{ $row->cost_price }}</td>
                        <td><a href="{{ URL::route('customer_receipt', ['customer_invoice_id' => $row->id]) }}" data-toggle="modal" data-target="#receipt"><i class="fa fa-file-text-o"></i></a></td>
                    </tr>
                @endforeach
            @else
                <tr><td colspan="6">No Records found</td></tr>
            @endif
        </tbody>
    </table>
</div>
<div class="modal-footer">
    <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
</div>

<script type="text/javascript">
    jQuery(document).ready(function()
    {        
//-------------------------------Invoice Details-------------------------------

        $('.datatable').on('click', '.quote_details', function ()
        {
            var val   = $(this).attr('id');
            var value = val.split('|');
            $("#quote_id").val(value[0]);
            $("#created_date").val(value[1]);
            $("#quote_lookup").modal('hide');
        });
    });
</script>