<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    Edit Service
                </div>
            </div>
            <div class="portlet-body">
                {{ Form::model($mnrService, [
                    'method' => 'PATCH',
                    'url' => ['/mnr_services', $mnrService->id],
                    'id' => 'mnr_service', 'class' => 'form-horizontal'
                ]) }}
                    {{ Form::hidden('type', null) }}
                    <?php $categoryType = ($mnrService->type == 1)?4:5?>
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Service Name<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('name', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Category<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCategories($categoryType) }}
                                    </div>
                                </div>
                                @if($mnrService->type == 2)
                                    <div class="form-group">
                                        <label class="control-label col-md-4">
                                            Url<span class="required"> * </span>
                                        </label>
                                        <div class="col-md-8">
                                            {{ Form::text('url', null, ['class' => 'form-control']) }}
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Amount<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-6">
                                        {{ Form::text('amount', floatval($mnrService->amount), ['class' => 'form-control']) }}
                                    </div>
                                    <div class="col-md-2">
                                        {{ getAmountType() }}
                                    </div>
                                </div>  
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Sort Order
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('sort_order', null, ['class' => 'form-control digits']) }}
                                    </div>
                                </div>
                            </div>      
                        </div>
                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-2 col-md-10">
                                {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                <button type="button" id="cancel" class="btn default">Cancel</button>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/mnr_services?type={{ $mnrService->type }}';
            return_page(url);
            return false;
        });
    });
</script>