<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    Edit Mobile Product
                </div>
            </div>
            <div class="portlet-body">
                {{ Form::model($product, [
                    'method' => 'PATCH',
                    'url' => ['/mobile_products', $product->id],
                    'id' => 'mobile_product', 'files' => true, 'class' => 'form-horizontal'
                ]) }}
                    {{ Form::hidden('image_name', null) }}
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Brand<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getBrands() }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Name<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('name', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        New Quantity
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('new_quantity', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Refurb Quantity
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('refurb_quantity', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Price<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('price', null, ['class' => 'form-control touchspin']) }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Image
                                    </label>
                                    <div class="col-md-8">
                                        <div class="fileinput fileinput-new" data-provides="fileinput">
                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                <?php $image =($product->image_name != '')?'images/mobile_images/'.$product->image_name.'?'.time():'http://www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image'?>
                                                <img src="{{ $image }}" alt="" />
                                            </div>
                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                                            <div>
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new"> Select image </span>
                                                    <span class="fileinput-exists"> Change </span>
                                                    <input type="file" name="image" id="image">  
                                                </span>
                                                <a href="javascript:;" class="btn red fileinput-exists" data-dismiss="fileinput"> Remove </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-2 col-md-10">
                                {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                <button type="button" id="cancel" class="btn default">Cancel</button>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/mobile_products';
            return_page(url);
            return false;
        });
    });
</script>