<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-settings"></i>
                    Networks
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-toolbar">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="btn-group">
                                <a href="{{ url('/networks/create') }}" class="btn sbold green ajaxify"> 
                                    Add New <i class="fa fa-plus"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table table-striped table-bordered table-hover datatable">
                    <thead> 
                        <tr>
                            <th>Name</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($networks as $row)
                            <tr>
                                <td>{{ $row->name }}</td>
                                <td>{!! setStatusHTML($row->id, $row->status) !!}</td>
                                <td>
                                    <a href="{{ url('/networks/'.$row->id.'/edit') }}" class="ajaxify"><i class="fa fa-edit"></i></a>
                                </td>
                            </tr>
                        @endforeach                    
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
//--------------------------------Update Status---------------------------------

        $('.update_status').click(function()
        {
            var message;
            var id   = $(this).attr('id');
            var status = $(this).children('button').attr('id');
            
            if(status == 1)
            {
                status  = 0;
                message = 'Are you sure you want to inactive status?';
            }else
            {
                status  = 1;
                message = 'Are you sure you want to active status?';
            }
            
            var data = 'id='+id+'&status='+status+'&_token={{ csrf_token() }}';
            var url  = base_url +'/networks/update_status';
            var return_url = base_url+'/networks';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call2(data, url, return_url);
                }
            });
            return false;    
        });
        
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
    });
</script>