<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-settings"></i>
                    Pin Numbers
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-toolbar">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="btn-group">
                                <a href="{{ url('/pin_numbers/create') }}" class="btn sbold green ajaxify"> 
                                    Add New <i class="fa fa-plus"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-body">
                    {{ Form::open(['url' => 'pin_numbers', 'method' => 'get', 'id' => 'pin_numbers', 'class' => 'form-horizontal']) }}
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="col-md-4">
                                    <div class="input-icon right">
                                        <label class="control-label margin-bottom-10">Pin Number</label>
                                        {{ Form::text('pin_number', $pinNumber, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-icon right">
                                        <label class="control-label margin-bottom-10">Category</label>
                                        {{ getCategoriesAdmin($categoryId) }}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-icon right">
                                        <label class="control-label margin-bottom-10">Product</label>
                                        {{ getProducts($categoryId, $productId, 0) }}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-icon right">
                                        <label class="control-label margin-bottom-10">Amount</label>
                                        {{ Form::text('amount', $amount, ['class' => 'form-control touchspin']) }}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-icon right">
                                        <label class="control-label margin-bottom-10">Status</label>
                                        {{ getStatus($status) }}
                                    </div>
                                </div>
                                <div class="col-md-3 margin-top-40">
                                    <button class="btn btn-sm yellow filter-submit"><i class="fa fa-search"></i> Search</button>
                                </div>
                            </div>
                        </div>
                    {{ Form::close() }}
                </div>
                <table class="table table-striped table-bordered table-hover" id="datatable">
                    <thead> 
                        <tr>
                            <th>Pin Number</th>
                            <th>Product</th>
                            <th>Amount</th>
                            <th>Expired Date</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
//--------------------------------Update Status---------------------------------

        $('#datatable').on('click', '.update_status', function ()
        {
            var message;
            var id   = $(this).attr('id');
            var status = $(this).children('button').attr('id');
            
            if(status == 1)
            {
                status  = 0;
                message = 'Are you sure you want to inactive status?';
            }else
            {
                status  = 1;
                message = 'Are you sure you want to active status?';
            }
            
            var data = 'id='+id+'&status='+status+'&_token={{ csrf_token() }}';
            var url  = base_url +'/pin_numbers/update_status';
            var return_url = base_url+'/pin_numbers';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call2(data, url, return_url);
                }
            });
            return false;    
        });
        
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//------------------------------------Lookup------------------------------------

        $('#pin_numbers').submit(function()
        {
            lookup($(this));
            return false;
        });

//-----------------------------------Get Date-----------------------------------

        var table = $('#datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/pin_numbers/get_data?pin_number={{ $pinNumber }}&category_id={{ $categoryId }}&product_id={{ $productId }}&amount={{ $amount }}&status={{ $status }}',
            'order': [
                [1, "asc"]
            ],
            'columns': [
                { data: 'pin_number' },
                { data: 'product_id' },
                { data: 'amount' },
                { data: 'expired_date' },
                { data: 'status' },
                { data: 'action', orderable: false, searchable: false}
            ]
        });

//---------------------------------Get Products---------------------------------

        $('#category_id').change(function()
        {
            var category_id = $(this).val();

            if(category_id != '')
            {
                $.get('transactions/'+category_id+'/get_products', function(data)
                {
                    $('#product_id').html(data);
                });
            }else
            {
                $('#product_id').html('');
            }
        });
    });
</script>