<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    Add Product
                </div>
            </div>
            <div class="portlet-body">
                {{ Form::open(['url' => '/products', 'id' => 'product', 'class' => 'form-horizontal']) }}
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Name<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('name', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Category<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCategoriesAdmin() }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Image
                                    </label>
                                    <div class="col-md-8">
                                        <div class="fileinput fileinput-new" data-provides="fileinput">
                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                <img src="http://www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" alt="" /> 
                                            </div>
                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                                            <div>
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new"> Select image </span>
                                                    <span class="fileinput-exists"> Change </span>
                                                    <input type="file" name="image" id="image">  
                                                </span>
                                                <a href="javascript:;" class="btn red fileinput-exists" data-dismiss="fileinput"> Remove </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label col-md-2">
                                        Description<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-10">
                                        {{ Form::textarea('description', null, ['class' => 'summernote form-control']) }}
                                    </div>
                                </div>
                                <h4 class="margin-top-40">Product Price</h4><hr>
                            </div>
                            <div class="col-md-12 margin-top-20 price">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">
                                                Card Price<span class="required"> * </span>
                                            </label>
                                            {{ getAmount() }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">
                                                Agent Price<span class="required"> * </span>
                                            </label>
                                            {{ Form::text('agent_price[]', null, ['class' => 'form-control touchspin']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">
                                                Cost Price<span class="required"> * </span>
                                            </label>
                                            {{ Form::text('cost_price[]', null, ['class' => 'form-control touchspin']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-1" style="margin-top: 26px">
                                    <a href="javascript:;" id="add_price" class="btn btn-icon-only green">
                                        <i class="fa fa-plus"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-1 col-md-10">
                                {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                <button type="button" id="cancel" class="btn default">Cancel</button>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//----------------------------------Add Price-----------------------------------
        
        $('#add_price').click(function()
        {
            var add = $('<div class="col-md-12 price">'+
                            '<div class="col-md-3">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                        '{{ getAmount() }}'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                            '<div class="col-md-3">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                        '{{ Form::text("agent_price[]", null, ["class" => "form-control touchspin"]) }}'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                            '<div class="col-md-3">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                        '{{ Form::text("cost_price[]", null, ["class" => "form-control touchspin"]) }}'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                            '<div class="col-md-1">'+
                                '<a href="javascript:;" class="btn btn-icon-only red-sunglo delete_price">'+
                                    '<i class="fa fa-minus"></i>'+
                                '</a>'+
                            '</div>'+
                        '</div>');
            
            $(".price:last").after(add);
            $('.select2').select2();
            $(".touchspin").TouchSpin({
                min: 0,
                max: 1000000,
                step: 0.1,
                decimals: 2,
                boostat: 5,
                maxboostedstep: 10
            });
            return false;
        });
        
//---------------------------------Remove Price---------------------------------

        $('.form-horizontal').on('click', '.delete_price', function()
        {
            $(this).parent().parent().remove();
            return false;
        });
        
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/products';
            return_page(url);
            return false;
        });
    });
</script>