<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('reports') }}" class="ajaxify">Reports</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    <div class="portlet box red">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                {{ $title }}
            </div>
        </div>
        <div class="portlet-body">
            <div class="form-body">
                {{ Form::open(['route' => 'sales_report', 'method' => 'get', 'id' => 'sales_report', 'class' => 'form-horizontal']) }}
                    {{ Form::hidden('customer_id', $customerId, ['id' => 'customer_id']) }}
                    <div class="form-group">
                        <div class="col-md-3">
                            <label class="control-label margin-bottom-10">Customer Name</label>
                            {{ Form::text('customer_name', $customerName, ['id' => 'customer_name', 'readonly' => '', 'class' => 'form-control']) }}
                        </div>
                        <div class="col-md-1" style="margin-top: 38px">
                            <a href="#basic" data-toggle="modal" class="btn green">Lookup</a>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label margin-bottom-10">From</label>
                            <div class="input-icon right">
                                <i class="fa fa-calendar"></i>
                                {{ Form::text('date_from', $dateFrom, ['class' => 'form-control date-picker', 'autocomplete' => 'off']) }}
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label margin-bottom-10">To</label>
                            <div class="input-icon right">
                                <i class="fa fa-calendar"></i>
                                {{ Form::text('date_to', $dateTo, ['class' => 'form-control date-picker', 'autocomplete' => 'off']) }}
                            </div>
                        </div>
                        <div class="col-md-2 margin-top-40">
                            <button class="btn btn-sm green filter-submit"><i class="fa fa-search"></i> Search</button>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
            <table class="table table-striped table-bordered table-hover margin-top-20" id="datatable">
                <thead>						
                    <tr>
                        <th>Order #</th>
                        <th>Order Date</th>
                        <th>Module Name</th>
                        <th>Sale Price</th>
                        <th>Cost Price</th>
                        <th>Print</th>
                    </tr>
                </thead>	 
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>
@include('customers.customer_lookup')
<div class="modal fade" id="receipt" tabindex="-1" role="basic" aria-hidden="true">
     <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();

//-----------------------------Sales Report Lookup------------------------------

        $('#sales_report').submit(function()
        {
            lookup($(this));
            return false;        
        });  
        
        var table = $('#datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/sales_report/get_data?customer_id={{ $customerId }}&date_from={{ $dateFrom }}&date_to={{ $dateTo }}',
            'order': [
                [0, 'desc']
            ],
            'columns': [
                { data: 'transaction_id' },
                { data: 'created_at' },
                { data: 'module.name', name: 'module.name' },
                { data: 'sale_price' },
                { data: 'cost_price' },
                { data: 'action', orderable: false, searchable: false}
            ]
        });        
    });
</script>