<?php $class = ($page == 1)?'green':'red';?>
@if($page == 2)
    <div class="title">
        <span class="offer">{{ $title }}</span>
    </div>
@endif
<div class="col-md-12">
    @if($page == 2)
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>
                    <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
                </li>
                <li>
                    <a href="{{ URL::route('unlocking_mobile_cover_page') }}" class="ajaxify">e-Unlocking Mobiles</a>
                </li>
                <li class="active">{{ $title }}</li>
            </ol>
        </div>
    @endif
    <div class="portlet box {{ $class }}">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                {{ $title }}
            </div>
            <div class="tools">
                <a href="{{ URL::route('unlocking_mobile_status', ['page' => 2]) }}" class="reload_1 ajaxify"> </a>
            </div>
        </div>
        <div class="portlet-body" style="min-height: 300px">
            <div class="actions pull-right margin-bottom-20">
                <div class="btn-group">
                    <a href="javascript:;" class="btn dark btn-outline btn-circle btn-sm dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true"> {{ ($interval == 0)?'Disabled':$interval.' Seconds' }}
                        <span class="fa fa-angle-down"> </span>
                    </a>
                    <ul class="dropdown-menu pull-right">
                        <li {{ ($interval == 0)?'class="active"':'' }}>
                            <a href="javascript:;" id="0" class="interval"> Disabled</a>
                        </li>
                        <li {{ ($interval == 5)?'class="active"':'' }}>
                            <a href="javascript:;" id="5" class="interval"> 5 Seconds</a>
                        </li>
                        <li {{ ($interval == 10)?'class="active"':'' }}>
                            <a href="javascript:;" id="10" class="interval"> 10 Seconds</a>
                        </li>
                        <li {{ ($interval == 15)?'class="active"':'' }}>
                            <a href="javascript:;" id="15" class="interval"> 15 Seconds</a>
                        </li>
                        <li {{ ($interval == 30)?'class="active"':'' }}>
                            <a href="javascript:;" id="30" class="interval"> 30 Seconds</a>
                        </li>
                        <li {{ ($interval == 60)?'class="active"':'' }}>
                            <a href="javascript:;" id="60" class="interval"> 60 Seconds</a>
                        </li>
                    </ul>
                </div>
            </div>
            <table class="table table-striped table-bordered table-hover margin-top-20">
                <thead>						
                    <tr>
                        <th>Order #</th>
                        <th>Order Date</th>
                        <th>Service</th>
                        <th>IMEI</th>
                        <th>Price</th>
                        <th>Comments</th>
                        <th>Response</th>
                        @if($page == 1)
                            <th style="width:150px;">Status</th>
                        @else
                            <th>Status</th>
                        @endif
                    </tr>
                </thead>	 
                <tbody id="result">
                    @include('reports.unlocking_mobile_child')
                </tbody>
            </table>
        </div>
    </div>
</div>
@if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))  
    @include('admin.unlocking_mobile_modal')
@endif
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//-----------------------------------Interval-----------------------------------

        var seconds = {{ $interval }};
        var time    = seconds * 1000;
        if(time > 0)
        {
            start_interval(time);    
        }    
    
//---------------------------Update Page Refresh Time---------------------------

        $('.interval').click(function()
        {
            var id = $(this).attr('id');
            
            var data = 'page_refresh_time='+id+'&_token={{ csrf_token() }}';
            var url  = base_url +'/settings/update_page_refresh_time';
            var return_url = "{{ URL::route('unlocking_mobile_status', ['page' => 2]) }}";
            
            ajax_call3(data, url, return_url);
            return false;    
        });
        
//------------------------Cancel Unlocking Mobile Order-------------------------
        
        @if($page == 2)
            
            $('#result').on('click', '.cancel', function()
            {
                var id = $(this).attr('id');
                var message = 'Are you sure you want to cancel order?';

                var data = 'id='+id+'&_token={{ csrf_token() }}';
                var url  = base_url +'/transactions/cancel_unlocking_mobile_order';
                var return_url = base_url+'/reports/unlocking_mobile_status?page=2';

                bootbox.confirm(message, function(result) 
                {
                    if(result == true)
                    {
                       ajax_call3(data, url, return_url);
                    }
                });
                return false;    
            });
        @endif
        
//-----------------------Unlocking Mobile Complete/Reject-----------------------

        @if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))

            $('#result').on('click', '.complete, .unlocking_mobile_reject', function()
            {
                var id = $(this).attr('id');
                var status = $(this).attr('status');
                var cost_price = $(this).attr('cost_price');

                if(status == 2)
                {
                    $('#refund').show();
                }else
                {
                    $('#refund').hide();
                }
                $('input[name="id"]').val(id);
                $('input[name="status"]').val(status);
                $('input[name="cost_price"]').val(cost_price);
                $('input[name="list"]').val(2);
                $('#unlocking_mobile_modal').modal('show');
            });
        @endif
    });
</script>