<?php $class = ($page == 1)?'green':'red';?>
@if($page == 2 || $page == 3)
    <div class="title">
        <span class="offer">{{ $title }}</span>
    </div>
@endif
<div class="col-md-12">
    @if($page == 2 || $page == 3)
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>
                    <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
                </li>
                @if($page == 2)
                    <li>
                        <a href="{{ URL::route('reports') }}" class="ajaxify">Reports</a>
                    </li>
                @else
                    <li>
                        <a href="{{ URL::route('unlocking_mobile_cover_page') }}" class="ajaxify">e-Unlocking Mobiles</a>
                    </li>
                @endif
                <li class="active">{{ $title }}</li>
            </ol>
        </div>
    @endif
    <div class="portlet box {{ $class }}">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                {{ $title }}
            </div>
            <div class="tools">
                <a href="/reports/unlocking_mobile_list?page={{ $page }}&user_id={{ $userId }}&date_from={{ $dateFrom }}&date_to={{ $dateTo }}" class="reload_1 ajaxify"> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="form-body">
                {{ Form::open(['route' => 'unlocking_mobile_list', 'method' => 'get', 'id' => 'unlocking_mobile_list', 'class' => 'form-horizontal']) }}
                    @include('reports.filter')
                {{ Form::close() }}
            </div>
           <table class="table table-striped table-bordered table-hover" id="datatable">
                <thead> 
                    <tr>
                        <th>Order #</th>
                        <th>Order Date</th>
                        <th>Service</th>
                        <th>IMEI</th>
                        <th>Price</th>
                        <th>Comments</th>
                        <th>Response</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>                
        </div>
    </div>
</div>
<div class="modal fade" id="receipt" tabindex="-1" role="basic" aria-hidden="true">
     <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
@include('admin.unlocking_mobile_modal')
@if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
    @include('reports.user_lookup',['groupId' => 4])
@endif
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//---------------------------Unlocking Mobile Lookup----------------------------

        $('#unlocking_mobile_list').submit(function()
        {
            lookup($(this));
            return false;        
        });  
        
        var table = $('#datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/unlocking_mobile/get_data?page={{ $page }}&user_id={{ $userId }}&date_from={{ $dateFrom }}&date_to={{ $dateTo }}',
            'order': [
                [0, 'desc']
            ],
            'columns': [
                { data: 'transaction_id' },
                { data: 'created_at' },
                { data: 'service.name', name: 'service.name' },
                { data: 'imei_number' },
                { data: 'price' },
                { data: 'comments' },
                { data: 'response' },
                { data: 'status' }
            ]
        });
        
//--------------------Unlocking Mobile In Process/Completed---------------------

        @if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
            
            $('#datatable').on('click', '.status', function()
            {
                var id = $(this).attr('id');
                var status = $(this).attr('status');

                $('input[name="id"]').val(id);
                $('input[name="status"]').val(status);
                $('input[name="list"]').val(1);
                $('#unlocking_mobile_modal').modal('show');
            });
        @endif
        
//------------------------Cancel Unlocking Mobile Order-------------------------

        $('#datatable').on('click', '.cancel', function()
        {
            var id = $(this).attr('id');
            var message = 'Are you sure you want to cancel order?';
            
            var data = 'id='+id+'&_token={{ csrf_token() }}';
            var url  = base_url +'/transactions/cancel_unlocking_mobile_order';
            var return_url = base_url+'/reports/unlocking_mobile_list';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call3(data, url, return_url);
                }
            });
            return false;    
        });        
    });
</script>