<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('settings') }}" class="ajaxify">{{ $title }}</a>
            </li>
            <li class="active">{{ $subTitle }}</li>
        </ol>
    </div>
    <div class="portlet box red">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-note"></i>
                {{ $subTitle }}
            </div>
        </div>
        <div class="portlet-body">
            {{ Form::open(['url' => '/custom_fields', 'id' => 'module', 'class' => 'form-horizontal']) }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group margin-top-20">
                                <label class="control-label col-md-4">
                                    Module<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ getModules() }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Name<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('name', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Sort Order
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('sort_order', 0, ['class' => 'form-control digits']) }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group margin-top-20">
                                <label class="control-label col-md-4">
                                    Field Type<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ getCustomFieldTypes() }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    After Amount
                                </label>
                                <div class="col-md-8">
                                    {{ getOptions() }}
                                </div>
                            </div>
                            <div id="field_values" class="form-group display-hide">
                                <label class="control-label col-md-4">
                                    Field Values<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    <div id="textarea" class="input-icon right">
                                        <i class="fa fa-info-circle tooltip" data-original-title="Must Enter Comma Separated (,) Values"></i>
                                        {{ Form::textarea('field_values', null, ['id' => 'fields', 'class' => 'form-control', 'size' => '30x3']) }}
                                    </div>
                                    <div id="amount">
                                        {{ getCustomFieldValues() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-offset-2 col-md-10">
                            {{ Form::submit('Submit', ['class' => 'btn dark']) }}
                            <button type="button" id="cancel" class="btn grey-mint">Cancel</button>
                        </div>
                    </div>
                </div>
            {{ Form::close() }}
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//----------------------------Show/Hide Field Values----------------------------

        $('#field_type_id').change(function()
        {
            var field_type = $(this).val();

            if(field_type == 2 || field_type == 5)
            {                
                $('#field_values').show();
                
                if(field_type == 2)
                {
                    $('#fields').attr('required', 'true');
                    $('#textarea').show();
                    $('#amount').hide();
                }else if(field_type == 5)
                {
                    $('#textarea').hide();
                    $('#amount').show();
                }
            }else
            {
                $('#fields').removeAttr('required');
                $('#field_values').hide();
            }
        });
    
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/settings';
            return_page(url);
            return false;
        });
    });
</script>