<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    <div class="portlet box red">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                Modules
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-toolbar">
                <div class="row">
                    <div class="col-md-6">
                        <div class="btn-group">
                            <a href="{{ url('/modules/create') }}" class="btn sbold red ajaxify"> 
                                Add New <i class="fa fa-plus"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <table class="table table-striped table-bordered table-hover datatable2">
                <thead> 
                    <tr>
                        <th>Name</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($modules as $row)
                        <tr>
                            <td>{{ $row->name }}</td>
                            <td>
                                @if($row->global == 0)
                                    <a href="{{ url('/modules/'.$row->id.'/edit') }}" class="ajaxify"><i class="fa fa-edit"></i></a>
                                @else
                                    <i class="fa fa-times-circle"></i>
                                @endif
                            </td>
                        </tr>
                    @endforeach                    
                </tbody>
            </table>
        </div>
    </div>
    <div class="portlet box red">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                Custom Fields
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-toolbar">
                <div class="row">
                    <div class="col-md-6">
                        <div class="btn-group">
                            <a href="{{ url('/custom_fields/create') }}" class="btn sbold red ajaxify"> 
                                Add New <i class="fa fa-plus"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <table class="table table-striped table-bordered table-hover datatable2">
                <thead> 
                    <tr>
                        <th>Name</th>
                        <th>Module</th>
                        <th>Field Type</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($customFields as $row)
                        <tr>
                            <td>{{ $row->name }}</td>
                            <td>{{ $row->module->name }}</td>
                            <td>{{ $row->fieldType->name }}</td>
                            <td>{!! setStatusHTML($row->id, $row->status) !!}</td>
                            <td>
                                <a href="{{ url('/custom_fields/'.$row->id.'/edit') }}" class="ajaxify"><i class="fa fa-edit"></i></a>
                            </td>
                        </tr>
                    @endforeach                    
                </tbody>
            </table>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//--------------------------------Update Status---------------------------------

        $('.update_status').click(function()
        {
            var message;
            var id   = $(this).attr('id');
            var status = $(this).children('button').attr('id');
            
            if(status == 1)
            {
                status  = 0;
                message = 'Are you sure you want to inactive status?';
            }else
            {
                status  = 1;
                message = 'Are you sure you want to active status?';
            }
            
            var data = 'id='+id+'&status='+status+'&_token={{ csrf_token() }}';
            var url  = base_url +'/custom_fields/update_status';
            var return_url = base_url+'/settings';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call3(data, url, return_url);
                }
            });
            return false;    
        });
        
        mnreHub.init();
    });
</script> 