<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    Add SIM Information
                </div>
            </div>
            <div class="portlet-body">
                {{ Form::open(['url' => '/sim_informations', 'id'=>'sim_informations', 'class' => 'form-horizontal']) }}
                    {{ Form::hidden('sim_information_id', $id) }}
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Network<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        @if($id == '')
                                            {{ getNetworks() }}
                                        @else 
                                            {{ Form::text('network_name', $networkName, ['readonly' => '', 'class' => 'form-control']) }}
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Expired Date<span class="required"> * </span></label>
                                    <div class="col-md-8">
                                        <div class="input-icon right">
                                            <i class="fa fa-calendar"></i>
                                            {{ Form::text('expired_date',null, ['class' => 'form-control date-picker', 'autocomplete' => 'off']) }}
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Product<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        @if($id == '')
                                            {{ Form::select('product_id', ['' => 'Select Product'], null, ['class' => 'form-control select2', 'id' => 'product_id']) }}
                                        @else 
                                            {{ Form::text('product_name', $productName, ['readonly' => '', 'class' => 'form-control']) }}
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <h4 class="margin-top-40">CLI Numbers</h4><hr>
                            </div>
                            <div class="col-md-12 margin-top-20 cli_numbers">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label margin-bottom-10">
                                                SSN<span class="required"> * </span>
                                            </label>
                                            {{ Form::text('ssn[]', null, ['id' => 'ssn0', 'class' => 'form-control']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label margin-bottom-10">
                                                CLI
                                            </label>
                                            {{ Form::text('cli[]', null, ['id' => 'cli0', 'class' => 'form-control']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-1" style="margin-top: 35px">
                                    <a href="javascript:;" id="add_cli_number" class="btn btn-icon-only green">
                                        <i class="fa fa-plus"></i>
                                    </a>
                                </div>
                                <div class="col-md-1" style="margin-top: 35px">
                                    {{ Form::text('cli_number', 1, ['id' => 'cli_number', 'class' => 'form-control']) }}
                                </div>
                            </div>
                        </div>
                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-2 col-md-10">
                                    {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                    <button type="button" id="cancel" class="btn default">Cancel</button>
                                </div>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function()
    {
        mnreHub.init();
        
        $(".ssn").keyup(function () 
        {
            $(this).nextAll('.ssn').focus();
        });

//---------------------------------Get Product----------------------------------

        $('#network_id').change(function()
        {
            var network_id = $(this).val();

            if(network_id != '')
            {
                $.get(base_url+'/sim_informations/'+network_id+'/get_products', function(data)
                {
                    $('#product_id').html(data);
                });
            }else
            {
                $('#product_id').html('');
            }
        });
        
//-------------------------------Add SSN and CLI--------------------------------
        
        var a = 0;
        
        $('#add_cli_number').click(function()
        {
            var field_no = $('#cli_number').val();
            
            if(field_no < 1)
            {
                field_no = 1;
            }
            
            for (var i = 1; i <= field_no; i++) 
            {
                var add = $('<div class="col-md-12 cli_numbers">'+
                                '<div class="col-md-4">'+
                                    '<div class="form-group">'+
                                        '<div class="col-md-12">'+
                                           '<input type="text" name="ssn[]" id="ssn'+a+'" class="form-control">'+
                                        '</div>'+
                                    '</div>'+
                                '</div>'+
                                '<div class="col-md-4">'+
                                    '<div class="form-group">'+
                                        '<div class="col-md-12">'+
                                            '<input type="text" name="cli[]" id="cli'+a+'" class="form-control">'+
                                        '</div>'+
                                    '</div>'+
                                '</div>'+
                                '<div class="col-md-1">'+
                                    '<a href="javascript:;" class="btn btn-icon-only red delete_cli_numbers">'+
                                        '<i class="fa fa-minus"></i>'+
                                    '</a>'+
                                '</div>'+
                            '</div>');

                $(".cli_numbers:last").after(add);
                a++;
            }
            return false;
        });
        
//------------------------------Remove SSN and CLI------------------------------

        $('.form-horizontal').on('click', '.delete_cli_numbers', function()
        {
            $(this).parent().parent().remove();
            return false;
        });

//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/sim_informations';
            return_page(url);
            return false;
        });
    });
</script>