<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
</div>
<div class="col-md-8">
    <div class="portlet box red">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-note"></i> Enter Banking Details
            </div>
        </div>
        <div class="portlet-body form">
            <div class="scroller" style="height: 305px;" data-always-visible="1" data-rail-visible="0">
                {{ Form::open(['url' => '/transactions/transaction', 'id' => 'banking', 'class' => 'form-horizontal']) }}
                     <div class="form-body">     
                        <div class="row">
                            <div class="form-group margin-top-20">
                                <label class="control-label col-md-3">
                                    Bank<span class="required"> * </span>
                                </label>
                                <div class="col-md-6">
                                    {{ getBanks($bank_id) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-3">
                                    Date<span class="required"> * </span>
                                </label>
                                <div class="col-md-6">
                                    {{ Form::text('date', null, ['class' => 'form-control date-picker']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-3">
                                    Amount<span class="required"> * </span>
                                </label>
                                <div class="col-md-6">
                                    {{ Form::text('amount', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-3">
                                    Payment Ref<span class="required"> * </span>
                                </label>
                                <div class="col-md-6">
                                    {{ Form::text('payment_ref', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-md-offset-3 col-md-6">
                                    {{ Form::submit('Submit', ['class' => 'btn dark']) }}
                                </div>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<div class="col-md-4">
    <div class="portlet box red">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                Credit Received
            </div>
        </div>
        <div class="portlet-body">
            <div class="scroller" style="height: 278px;" data-always-visible="1" data-rail-visible="0">
                @if($bank_id == 0)
                    <table class="table table-striped table-bordered table-hover margin-top-20">
                        <thead> 
                            <tr>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Mode</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($banking as $row)
                                <tr>
                                    <td>{{ $row->amount }}</td>
                                    <td>{{ $row->date }}</td>
                                    <td>Bank</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    @if(count($banking) > 0)
                        <div class="row static-info">
                            <div class="col-md-5 name">Account Name:</div>
                            <div class="col-md-7 value">{{ $banking->account_name }}</div>
                        </div>
                        <div class="row static-info">
                            <div class="col-md-5 name">Bank:</div>
                            <div class="col-md-7 value">{{ $banking->bank->name }}</div>
                        </div>
                        <div class="row static-info">
                            <div class="col-md-5 name">Sort Code:</div>
                            <div class="col-md-7 value">{{ $banking->sort_code }}</div>
                        </div>
                        <div class="row static-info">
                            <div class="col-md-5 name">Account Number:</div>
                            <div class="col-md-7 value">{{ $banking->account_number }}</div>
                        </div>
                        <div class="row static-info">
                            <div class="col-md-12 value"> 
                                <br>TO AVIOD DELAY FOR GETTING CREDIT<br>
                                PLEASE ADD YOUR PAYMENT REFERENCE <br>
                                REF: First Name and last 5 digits of your registered mobile number.
                            </div>
                        </div>
                    @else
                        <div class="row static-info">
                            <div class="col-md-12 value">No Bank Account Found</div>
                        </div>
                    @endif
                @endif
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//-------------------------------Get Bank Account-------------------------------

        $('#bank_id').change(function()
        {
            var bank_id = $(this).val();
            
            if(bank_id == '')
            {
                bank_id = 0;
            }
            
            var url = base_url +'/transactions/transaction?bank_id='+bank_id; 
            return_page(url);
            return false;
        });
    });
</script>