<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            @if($type == 2)
                <li>
                    <a href="{{ URL::route('cargo_service_cover_page') }}" class="ajaxify">e-Cargo Service</a>
                </li>
            @endif
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    <div id="portlet" class="portlet light portlet-fit">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo">
                    {{ $title }}
                </span>
            </div>
        </div>
        <div class="portlet-body">                
            <div class="form-body">
                {{ Form::open(['url' => '/transactions/courier_service_detail', 'id' => 'courier_service_detail', 'class' => 'form-horizontal']) }}
                    {{ Form::hidden('type', $type) }}
                    @if($type == 2)
                        {{ Form::hidden('cargo_type', $cargoType) }}
                        {{ Form::hidden('cargo_service_rate_id', null, ['id' => 'cargo_service_rate_id']) }}
                        {{ Form::hidden('cargo_rate', null, ['id' => 'cargo_rate']) }}
                    @endif
                    {{ Form::hidden('collection_table_id', 1) }}
                    <div class="row">
                        <div class="col-md-12">
                            <h4 class="unlocking margin-top-40">Parcel Information</h4>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group margin-top-20">
                                <label class="control-label col-md-3">
                                    Parcel Contents<span class="required"> * </span>
                                </label>
                                <div class="col-md-7">
                                    {{ Form::text('parcel_contents', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group margin-top-20">
                                <label class="control-label col-md-3">
                                    Estimated Value<span class="required"> * </span>
                                </label>
                                <div class="col-md-7">
                                    {{ Form::text('estimated_value', null, ['class' => 'form-control touchspin']) }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 parcels">
                            <label class="control-label col-md-1 parcel">Parcel # 1</label> 
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        @if($type == 1)
                                            {{ Form::text('item_name[]', null, ['placeholder' => 'Item Name', 'id' => 'item_name1', 'class' => 'form-control']) }}
                                        @elseif($type == 2)
                                            {{ Form::textarea('item_name[]', null, ['class' => 'form-control', 'id' => 'item_name1', 'size' => '30x2']) }}
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <div class="input-group">
                                            {{ Form::text('weight[]', null, ['placeholder' => 'Weight', 'id' => 'weight1', 'class' => 'form-control']) }}
                                            <span class="input-group-addon">KG</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <div class="input-group">
                                            {{ Form::text('dim1[]', null, ['placeholder' => 'Length', 'id' => 'dim11', 'class' => 'form-control']) }}
                                            <span class="input-group-addon">CMX</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <div class="input-group">
                                            {{ Form::text('dim2[]', null, ['placeholder' => 'Width', 'id' => 'dim21', 'class' => 'form-control']) }}
                                            <span class="input-group-addon">CMX</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <div class="input-group">
                                            {{ Form::text('dim3[]', null, ['placeholder' => 'Height', 'id' => 'dim31', 'class' => 'form-control']) }}
                                            <span class="input-group-addon">CM</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <a href="javascript:;" id="add_parcel" class="btn btn-icon-only grey-mint">
                                    <i class="fa fa-plus"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <h4 class="unlocking margin-top-40">Collection & Delivery Country</h4>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Collection Country<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCountries('collection_country_id') }}
                                    </div>
                                </div>
                                @if($type == 2)
                                    <div class="form-group">
                                        <label class="control-label col-md-4">
                                            Cargo Service<span class="required"> * </span>
                                        </label>
                                        <div class="col-md-8">
                                            {{ Form::select('cargo_service_id', ['' => ''], null, ['data-placeholder' => 'Select Cargo Service', 'id' => 'cargo_service_id', 'class' => 'form-control select2']) }}
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Delivery Country<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        @if($type == 1)
                                            {{ getCountries('delivery_country_id') }}
                                        @elseif($type == 2)
                                            {{ Form::select('delivery_country_id', ['' => ''], null, ['data-placeholder' => 'Select Delivery Country', 'id' => 'delivery_country_id', 'class' => 'form-control select2']) }}
                                        @endif    
                                    </div>
                                </div>  
                                @if($type == 2)
                                    <div class="form-group">
                                        <label class="control-label col-md-4">
                                            Rate
                                        </label>
                                        <div class="col-md-8">
                                            <label id="rate" style="padding-top: 8px; font-weight: bold"></label>
                                        </div>
                                    </div>   
                                @endif                        
                            </div>
                        </div>
                        <div class="col-md-6 margin-top-20">
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <span class="caption-subject lineheight font-dark">Collection Address</span>
                                    </div>
                                    <div class="actions">
                                        <a href="{{ url('transactions/courier_address?address_type=1&table=0') }}" id="new_collection" class="btn red btn-circle courier display-hide" data-toggle="modal" data-target="#address_modal">New</a>
                                    </div>
                                </div>
                                <div class="form-group margin-top-20">
                                    <label class="col-md-4 control-label">Customer <span class="required" aria-required="true">*</span></label>
                                    <div class="col-md-6">
                                        {{ Form::text('customer_name', null, ['id' => 'customer_name', 'readonly' => '', 'class' => 'form-control']) }}
                                        {{ Form::hidden('customer_id', null, ['id' => 'customer_id']) }}
                                    </div>
                                    <div class="col-md-2">
                                        <a href="#basic" data-toggle="modal" class="btn red customer_lookup" style="margin-left: -10px">Lookup</a>
                                    </div>
                                </div>
                                <div id="user_profile" class="row">
                                    @include('transactions.courier_user_profile')
                                </div>
                                <div id="collection_addresses"></div>
                            </div>
                        </div>
                        <div class="col-md-6 margin-top-20">
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption">
                                        <span class="caption-subject lineheight font-dark">Delivery Address</span>
                                    </div>
                                    <div class="actions">
                                        <a href="{{ url('transactions/courier_address?address_type=2&table=0') }}" id="new_delivery" class="btn red btn-circle courier display-hide" data-toggle="modal" data-target="#address_modal">New</a>
                                    </div>
                                </div>       
                                <div class="form-group margin-top-20">
                                    <label class="col-md-4 control-label">Customer <span class="required" aria-required="true">*</span></label>
                                    <div class="col-md-8">
                                        {{ Form::text('delivery_customer_name', null, ['id' => 'delivery_customer_name', 'readonly' => '', 'class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div id="delivery_addresses"></div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 collectin-btn margin-top-10">
                                {{ Form::submit('Submit', ['class' => 'btn dark']) }}
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>    
</div>
@include('customers.customer_lookup')
<div class="modal fade" id="address_modal" role="basic" aria-hidden="true">
    <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
                
//----------------------------------Add Parcel----------------------------------
        
        var i = 2;
        
        $('#add_parcel').click(function()
        {
            var item_name = '';
            var a = $('.parcels').length + 1;
            
            @if($type == 1)
                item_name = '<input type="text" name="item_name[]" placeholder="Item Name" id="item_name'+i+'" class="form-control">';
            @elseif($type == 2)
                item_name = '<textarea name="item_name[]" id="item_name'+i+'" class="form-control"></textarea>';
            @endif
              
            var add = $('<div class="col-md-12 parcels">'+
                            '<label class="control-label col-md-1 parcel">Parcel # '+a+'</label>'+ 
                            '<div class="col-md-2">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                        item_name+
                                    '</div>'+
                                '</div>'+ 
                            '</div>'+
                            '<div class="col-md-2">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                        '<div class="input-group">'+
                                            '<input type="text" name="weight[]" placeholder="Weight" id="weight'+i+'" class="form-control">'+
                                            '<span class="input-group-addon">KG</span>'+
                                        '</div>'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                            '<div class="col-md-2">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                        '<div class="input-group">'+
                                            '<input type="text" name="dim1[]" placeholder="Length" id="dim1'+i+'" class="form-control">'+
                                            '<span class="input-group-addon">CMX</span>'+
                                        '</div>'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                            '<div class="col-md-2">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                        '<div class="input-group">'+
                                            '<input type="text" name="dim2[]" placeholder="Width" id="dim2'+i+'" class="form-control">'+
                                            '<span class="input-group-addon">CMX</span>'+
                                        '</div>'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                            '<div class="col-md-2">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                        '<div class="input-group">'+
                                            '<input type="text" name="dim3[]" placeholder="Height" id="dim3'+i+'" class="form-control">'+
                                            '<span class="input-group-addon">CM</span>'+
                                        '</div>'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                            '<div class="col-md-1">'+
                                '<a href="javascript:;" class="btn btn-icon-only red-sunglo delete_parcel">'+
                                    '<i class="fa fa-minus"></i>'+
                                '</a>'+
                            '</div>'+
                        '</div>');
            
            $(".parcels:last").after(add);
            
            i++;
            return false;
        });
        
//--------------------------------Remove Parcel---------------------------------

        $('.form-horizontal').on('click', '.delete_parcel', function()
        {
            $(this).parent().parent().remove();
            
            $('.parcel').each(function(i) {
                var a = i + 1;
                $(this).html('Parcel # '+a);
            });
            return false;
        });
        
//----------------------------Get Delivery Countries----------------------------
    
        get_delivery_countries($('#country_id').val());
    
        $('select[name=collection_country_id]').change(function()
        {
            var country_id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
            
            $('#delivery_country_id').empty().trigger('change');
            $('#cargo_service_id').empty().trigger('change');
            $('#cargo_rate').val('');
            $('#rate').html('');
            $('#new_delivery').hide();
            $('#delivery_addresses').html('');
            
            get_delivery_countries(country_id);
            
            App.unblockUI('#portlet');
        });
        
        function get_delivery_countries(country_id)
        {
            var customer_id = $('#customer_id').val();
            $('#new_collection').show();
            
            if(country_id != '')
            {
                @if($type == 2)
                    $.get(base_url+'/transactions/get_delivery_countries?cargo_type={{ $cargoType }}&country_id='+country_id, function(data)
                    {
                        $('#delivery_country_id').html(data);
                    });
                @endif
                
                if(customer_id != '')
                {
                    $.get('transactions/filter_courier_addresses?address_type=1&country_id='+country_id+'&customer_id='+customer_id, function(data) 
                    {
                        $("#collection_addresses").html(data);
                    });

                    $('#new_collection').attr('href', 'transactions/courier_address?address_type=1&table=0&country_id='+country_id+'&customer_id='+customer_id);

                }else
                {
                    $("#collection_addresses").html('');
                    $('#new_collection').attr('href', 'transactions/courier_address?address_type=1&table=0&country_id='+country_id);
                }
            }
        }
        
//------------------------------Get Cargo Service-------------------------------

        $('select[name=delivery_country_id]').change(function()
        {
            var customer_id = $('#customer_id').val();
            var collection_country_id = $('#country_id').val();
            var delivery_country_id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
            
            $('#cargo_service_id').empty().trigger('change');
            $('#cargo_rate').val('');
            $('#rate').html('');
            $('#new_delivery').show();
            
            if(delivery_country_id != null)
            {
                @if($type == 2)
                    $.get(base_url+'/transactions/get_cargo_services?cargo_type={{ $cargoType }}&collection_country_id='+collection_country_id+'&delivery_country_id='+delivery_country_id, function(data)
                    {
                        $('#cargo_service_id').html(data);
                    });
                @endif
                
                if(customer_id != '')
                {
                    $.get('transactions/filter_courier_addresses?address_type=2&country_id='+delivery_country_id+'&customer_id='+customer_id, function(data) 
                    {
                        $('#delivery_addresses').html(data);
                    });

                    $('#new_delivery').attr('href', 'transactions/courier_address?address_type=2&table=0&country_id='+delivery_country_id+'&customer_id='+customer_id);
                }else
                {
                    $('#delivery_addresses').html('');
                    $('#new_delivery').attr('href', 'transactions/courier_address?address_type=2&table=0&country_id='+delivery_country_id);
                }
            }
            
            App.unblockUI('#portlet');
        });
        
//----------------------------Get Cargo Service Rate----------------------------

    @if($type == 2)
    
        $('#cargo_service_id').change(function()
        {
            var collection_country_id = $('#country_id').val();
            var delivery_country_id = $('#delivery_country_id').val();
            var cargo_service_id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
            
            if(cargo_service_id != null)
            {
                $.getJSON(base_url+'/transactions/get_cargo_rate?cargo_type={{ $cargoType }}&collection_country_id='+collection_country_id+'&delivery_country_id='+delivery_country_id+'&cargo_service_id='+cargo_service_id, function(data)
                {
                    $('#cargo_service_rate_id').val(data.id);
                    $('#cargo_rate').val(data.rate);
                    $('#rate').html('****');
                });
            }else
            {
                $('#cargo_service_rate_id').val('');
                $('#cargo_rate').val('');
                $('#rate').html('');
            }
            App.unblockUI('#portlet');
        });
    @endif    
    
//----------------------------Get Collection Address----------------------------

        $('.form-horizontal').on('change', '.get_collection_address', function()
        {
            var table = $(this).attr('id');
            var id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
            
            if(table == 2)
            {
                $('#default_collection_address').html($('#address_'+id).html());
                $('#collection_toggle').removeClass("courier_collapse").addClass("courier_expand");
                $('#collection').slideUp(200);
            }
            
            $('input[name=collection_table_id]').val(table);
           
            App.unblockUI('#portlet');
        });

//--------------------------Toogle Collection Address---------------------------

        $('.form-horizontal').on('click', '#collection_toggle', function(e) {
            e.preventDefault();
            var el = $('#collection');
            if ($(this).hasClass("courier_collapse")) {
                $(this).removeClass("courier_collapse").addClass("courier_expand");
                el.slideUp(200);
            } else {
                $(this).removeClass("courier_expand").addClass("courier_collapse");
                el.slideDown(200);
            }
        });
        
//-----------------------------Get Delivery Address-----------------------------

        $('.form-horizontal').on('change', '.get_delivery_address', function()
        {
            var id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
             
            $('#default_delivery_address').html($('#address_'+id).html());
            $('#delivery_toggle').removeClass("courier_collapse").addClass("courier_expand");
            $('#delivery').slideUp(200);
            App.unblockUI('#portlet');
        });
        
//---------------------------Toogle Delivery Address----------------------------

        $('.form-horizontal').on('click', '#delivery_toggle', function(e) {
            e.preventDefault();
            var el = $('#delivery');
            if ($(this).hasClass("courier_collapse")) {
                $(this).removeClass("courier_collapse").addClass("courier_expand");
                el.slideUp(200);
            } else {
                $(this).removeClass("courier_expand").addClass("courier_collapse");
                el.slideDown(200);
            }
        });
        
//----------------------------Delivery Customer Name----------------------------

        $('.customer_datatable').on('click', '.customer_details', function ()
        {
            var val   = $(this).attr('id');
            var value = val.split('|');
            var collection_country_id = $('select[name=collection_country_id]').val();
            var delivery_country_id = $('select[name=delivery_country_id]').val();
            $("#delivery_customer_name").val(value[1]);
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
            
            if(collection_country_id != '' && delivery_country_id != '')
            {
                $.get('transactions/filter_courier_addresses?address_type=1&country_id='+collection_country_id+'&customer_id='+value[0], function(data) 
                {
                    $("#collection_addresses").html(data);
                });

                $.get('transactions/filter_courier_addresses?address_type=2&country_id='+delivery_country_id+'&customer_id='+value[0], function(data) 
                {
                    $('#delivery_addresses').html(data);
                });
            
                $('input[name=collection_table_id]').val(1);

                $('#new_collection').attr('href', 'transactions/courier_address?address_type=1&table=0&country_id='+collection_country_id+'&customer_id='+value[0]);
                $('#new_delivery').attr('href', 'transactions/courier_address?address_type=2&table=0&country_id='+delivery_country_id+'&customer_id='+value[0]);
            }else 
            {
                toastr_call(2, "Please select first Collection Country and Delivery Country");
            }
            
            App.unblockUI('#portlet');
        });

//-----------------------------Show/Hide Cargo Rate-----------------------------

        $('#rate').hover(function functionName() 
        {
            $('#rate').html({{ getGlobalValue('currency') }}+$('#cargo_rate').val());            
        }, function () {
            $('#rate').html('****');
        });
    });
</script>