<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('courier_service', ['type' => 1]) }}" class="ajaxify">e-Courier Service</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
</div>
@if(count($jsonArray['ServiceOptions']) > 0)
    @foreach($jsonArray['ServiceOptions'] as $value) 
        {{ Form::open(['url' => '/transactions/courier_service', 'id' => 'courier_service_'.$value['OptionID'], 'class' => 'form-horizontal']) }}
            {{ Form::hidden('quote_id', $jsonArray['QuoteID']) }}
            {{ Form::hidden('item_id', $value['OptionID']) }}
            {{ Form::hidden('sub_total', $value['SubTotal']) }}
            {{ Form::hidden('vat_total', $value['VatTotal']) }}
            {{ Form::hidden('total_price', $value['TotalPrice']) }}       
            {{ Form::hidden('collection_id', $collectionId) }}  
            {{ Form::hidden('collection_table_id', $collectionTableId) }}  
            {{ Form::hidden('delivery_id', $deliveryId) }}
            {{ Form::hidden('customer_id', $customerId) }}
            {{ Form::hidden('customer_name', $customerName) }}
            <div class="col-md-4">
                <div class="portlet light portlet-fit bordered">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject font-dark uppercase"> {{ $value['ServiceName'] }}</span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                            <div class="col-md-7 margin-bottom-12">
                                <img src="{{ $value['ServiceIcon'] }}" alt="{{ $value['ServiceName'] }}">
                            </div>
                            <div class="col-md-5 text-right">
                                <a href="{{ url('/transactions/courier_info?type=1&printer='.$value['Printer']) }}" data-toggle="modal" data-target=".courier_info" class="btn btn-icon-only purple">
                                    @if($value['Printer'] == 1)
                                    <i class="fa fa-print" title="Optional"></i>
                                    @elseif($value['Printer'] == 2)
                                        <i class="fa fa-print" title="Required"></i>
                                    @elseif($value['Printer'] == 3)
                                        <i class="fa fa-print" title="Not Required"></i>
                                    @endif
                                </a>
                                <a href="{{ url('/transactions/courier_info?type=2&service_name='.$value['OptionID']) }}" data-toggle="modal" data-target=".courier_info" class="btn btn-icon-only blue">    
                                    <i class="fa fa-lock"></i>
                                </a>
                                <a href="{{ url('/transactions/courier_info?type=3&service_name='.$value['OptionID']) }}" data-toggle="modal" data-target=".courier_info" class="btn btn-icon-only red">
                                    <i class="fa fa-info-circle"></i>
                                </a>
                                <p class="margin-top-10"><b>Estimated delivery time:</b> {{ $value['ETA'] }}</p>
                            </div>
                            <div class="static-info">
                                <div class="col-md-2 font-red-sunglo bold"> Price </div>
                                <div class="col-md-7 value"> 
                                    {{ getGlobalValue('currency') }}{{ $value['SubTotal'] }} (<small>inc VAT {{ getGlobalValue('currency') }}{{ $value['TotalPrice'] }}</small>)
                                </div>
                            </div>
                            <div class="col-md-12 newquote">
                                <p class="height"><small>Collection {{ date('l', strtotime($value['CollectionDates'][0]['date'])) }} {{ $value['CollectionDates'][0]['cutoff'] }}</small></p>
                                <div class="collect-field">
                                    <?php foreach($value['CollectionDates'] as $val):
                                            $date = date_create($val['date']);
                                            $data[$val['date']] = date_format($date, 'l jS F');
                                        endforeach; ?>
                                    {{ Form::select('collection_date', 
                                        $data
                                        , null, [ 
                                            'class' => 'form-control select2'
                                    ]) }}
                                </div>
                                <div class="collect-btn">
                                    {{ Form::submit('Submit', ['class' => 'btn dark courier_service']) }}
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
            </div>
        {{ Form::close() }}
    @endforeach
@else
    <div class="col-md-3"></div>
    <div class="col-md-6">
        <div class="alert alert-info margin-top-40">
            <strong>info!</strong>
            Not Service Exist!
        </div>
    </div>
    <div class="col-md-3"></div>
@endif
<div class="modal fade courier_info" role="basic" aria-hidden="true">
    <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<!--<div class="modal fade" id="cover_info" role="basic" aria-hidden="true">
    <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<div class="modal fade" id="parcel_info" role="basic" aria-hidden="true">
    <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>-->
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        $('.courier_service').click(function()
        {
            var return_url = base_url +'/transactions/courier_service?type=1';
            var form = $(this).closest("form");
            ajax_call($(form), return_url);
            return false;
        });
    });
</script>