<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    <div class="portlet light portlet-fit">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo">Pricing</span>
            </div>
            <div class="actions">
                <div class="btn-group">
                    <button id="price" class="btn red-sunglo btn-outline sbold uppercase">{{ getGlobalValue('currency') }}None</button>
                </div>
            </div>
        </div>
        <div class="portlet-body">
            {{ Form::open(['url' => '/transactions/instant_credit', 'id' => 'instant_credit', 'class' => 'form-horizontal']) }}
                {{ Form::hidden('payment_method', null) }}
                <div class="form-body">
                    <div class="pricing-content-1">
                        <div class="row">
                            @for($i = 100; $i <= 500; $i+=50)
                                <div class="col-xs-6 col-sm-2">
                                    <div class="product-item">
                                        <span id="select_{{ $i }}" class="ribbon-featured display-hide">
                                            <strong class="ribbon">Selected</strong>
                                        </span>
                                        <div class="amount"><h1>{{ getGlobalValue('currency') }}{{ $i }}</h1></div>
                                        <a href="javascript:;" id="{{ $i }}" class="select-option-link btn btn-select credit">Select Amount</a>
                                    </div>
                                </div>
                                @if($i == 350)
                                    </div><div class="row margin-top-20">
                                @endif
                            @endfor
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group margin-top-40">
                            <label class="control-label col-md-2">
                                Amount<span class="required"> * </span>
                            </label>
                            <div class="col-md-8">
                                {{ Form::text('amount2', null, ['id' => 'amount', 'class' => 'form-control', 'autocomplete' => 'off']) }}
                                {{ Form::hidden('amount', null) }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-actions form-body">
                    <div class="row">
                        <div class="col-md-offset-4 col-md-8 margin-bottom-40 margin-top-40">
                            <input type="image" name="submit" src="{{ asset('packages/mnr_ehub/img/stripe.png') }}" id="stripe" border="0" alt="Submit" />
                            <input type="image" name="submit" src="{{ asset('packages/mnr_ehub/img/paypal.png') }}" id="paypal" border="0" alt="Submit" />
                        </div>
                    </div>
                </div>
            {{ Form::close() }}
        </div>
    </div>
</div>

<script type="text/javascript"> 
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if($errors && !$errors->isEmpty())
            <?php $err = '';?>
            @foreach ($errors->all() as $error)
                <?php $err .= $error; ?>
            @endforeach
            toastr_call(2, "{{ $err }}");
        @endif
                    
//--------------------------------Payment Method--------------------------------

        $('#stripe, #paypal').click(function()
        {
            var id = $(this).attr('id');          
            $('input[name=payment_method]').val(id);
        });

//----------------------------------Get Price-----------------------------------

        $('.credit').click(function ()
        {
            var price = $(this).attr('id');

            $('input[name=amount]').val(price);
            $('#price').html("{{ getGlobalValue('currency') }}"+price);
            
            $('.ribbon-featured').hide();
            
            $('#select_'+price).show();
        });
        
        $('#amount').keyup(function ()
        {
            var price = $(this).val();

            $('input[name=amount]').val(price);
            $('#price').html("{{ getGlobalValue('currency') }}"+price);
        });
    });
</script>