<!DOCTYPE html>
<!-- 
Template Name: Metronic - Responsive Admin Dashboard Template build with Twitter Bootstrap 3.3.6
Version: 4.5.6
Author: KeenThemes
Website: http://www.keenthemes.com/
Contact: support@keenthemes.com
Follow: www.twitter.com/keenthemes
Dribbble: www.dribbble.com/keenthemes
Like: www.facebook.com/keenthemes
Purchase: http://themeforest.net/item/metronic-responsive-admin-dashboard-template/4021469?ref=keenthemes
Renew Support: http://themeforest.net/item/metronic-responsive-admin-dashboard-template/4021469?ref=keenthemes
License: You must have a valid license purchased only from themeforest(the above link) in order to legally use the theme for your project.
-->
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en">
    <!--<![endif]-->
    <!-- BEGIN HEAD -->
    <head>
        <meta charset="utf-8" />
        <title>:: {{ Config::get('acl_base.app_name') }} ::</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="width=device-width, initial-scale=1" name="viewport" />
        <meta content="" name="description" />
        <meta content="" name="author" />
        <!-- BEGIN GLOBAL MANDATORY STYLES -->
        <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
        <link href="{{ asset('packages/metronic/global/plugins/font-awesome/css/font-awesome.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('packages/metronic/global/plugins/simple-line-icons/simple-line-icons.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('packages/metronic/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('packages/metronic/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css') }}" rel="stylesheet" type="text/css" />
        <!-- END GLOBAL MANDATORY STYLES -->
        <!-- BEGIN PAGE LEVEL PLUGINS -->
        <link href="{{ asset('packages/metronic/global/plugins/bootstrap-toastr/toastr.min.css') }}" rel="stylesheet" type="text/css" />
        <!-- END PAGE LEVEL PLUGINS -->
        <!-- BEGIN THEME GLOBAL STYLES -->
        <link href="{{ asset('packages/metronic/global/css/components.min.css') }}" rel="stylesheet" id="style_components" type="text/css" />
        <link href="{{ asset('packages/metronic/global/css/plugins.min.css') }}" rel="stylesheet" type="text/css" />
        <!-- END THEME GLOBAL STYLES -->
        <!-- BEGIN PAGE LEVEL STYLES -->
        <!-- END PAGE LEVEL STYLES -->
        <!-- BEGIN THEME LAYOUT STYLES -->
        <link href="{{ asset('packages/metronic/layouts/layout5/css/layout.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('packages/metronic/layouts/layout5/css/custom.css') }}" rel="stylesheet" type="text/css" />
        <!-- END THEME LAYOUT STYLES -->
        <link rel="shortcut icon" href="favicon.ico" /> 
    </head>
   <!-- END HEAD -->
    <body class="page-header-fixed page-sidebar-closed-hide-logo">
        <?php $companyProfile = getCompanyProfile(); ?>
        <!-- BEGIN CONTAINER -->
        <div id="no_print" class="wrapper">
            <!-- BEGIN HEADER -->
            @include('layouts.includes.header')
            <!-- END HEADER -->
            <div class="container-fluid">
                <div class="page-content">
                    <!-- BEGIN SIDEBAR CONTENT LAYOUT -->
                    <div class="page-content-container">
                        <div class="page-content-row">
                            <div class="title">
                                <span class="offer">Receipt</span>
                            </div>
                            <div class="col-md-12">
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-red-sunglo">
                                            <i class="icon-settings font-red-sunglo"></i>
                                            <span class="caption-subject bold uppercase">Receipt</span>
                                        </div>
                                    </div>
                                    <div class="print-body">
                                        @if($message == 'Completed')
                                            <div id="print-body">
                                                <div class="row static-info">
                                                    <div class="col-md-3 name">Date:</div>
                                                    <div class="col-md-9 value">{{ $date }}</div>
                                                </div>
                                                <div class="row static-info">
                                                    <div class="col-md-12 value">Purchase Amount</div>
                                                </div>
                                                <div class="row static-info">
                                                    <div class="col-md-3 name">Amount Selected</div>
                                                    <div class="col-md-9 value">{{ getGlobalValue('currency') }}{{ $amount }}</div>
                                                </div>
                                                <div class="row static-info">
                                                    <div class="col-md-3 name">Charges</div>
                                                    <div class="col-md-9 value">{{ $charges }}</div>
                                                </div>
                                                <div class="row static-info">
                                                    <div class="col-md-3 name">Total</div>
                                                    <div class="col-md-9 value">{{ getGlobalValue('currency') }}{{ $total }}</div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <a href="javascript:;" onclick="print()" class="btn dark btn-outline">Print</a>
                                            </div>
                                        @else
                                            <div class="row static-info">
                                                <div class="col-md-offset-2 col-md-8 value">
                                                    <h3 class="margin-bottom-30 font-red-sunglo"><b>{{ $message }}</b></h3>
                                                </div>
                                            </div>
                                        @endif
                                    </div>                         
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- END SIDEBAR CONTENT LAYOUT -->
                </div>
                <!-- BEGIN FOOTER -->
                @include('layouts.includes.footer')
                <!-- END FOOTER -->
            </div>
        </div>
        <!-- END CONTAINER -->
        <!-- BEGIN JS SCRIPT -->
        <!--[if lt IE 9]>
        <script src="{{ asset('packages/metronic/global/plugins/respond.min.js') }}"></script>
        <script src="{{ asset('packages/metronic/global/plugins/excanvas.min.js') }}"></script> 
        <![endif]-->
        <!-- BEGIN CORE PLUGINS -->
        <script src="{{ asset('packages/metronic/global/plugins/jquery.min.js') }}" type="text/javascript"></script>
        <script src="{{ asset('packages/metronic/global/plugins/bootstrap/js/bootstrap.min.js') }}" type="text/javascript"></script>
        <script src="{{ asset('packages/metronic/global/plugins/js.cookie.min.js') }}" type="text/javascript"></script>
        <script src="{{ asset('packages/metronic/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js') }}" type="text/javascript"></script>
        <script src="{{ asset('packages/metronic/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js') }}" type="text/javascript"></script>
        <script src="{{ asset('packages/metronic/global/plugins/jquery.blockui.min.js') }}" type="text/javascript"></script>
        <script src="{{ asset('packages/metronic/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js') }}" type="text/javascript"></script>
        <!-- END CORE PLUGINS -->
        <!-- BEGIN PAGE LEVEL PLUGINS -->
        <script src="{{ asset('packages/metronic/global/plugins/bootstrap-toastr/toastr.min.js') }}" type="text/javascript"></script>
        <!-- END PAGE LEVEL PLUGINS -->
        <!-- BEGIN THEME GLOBAL SCRIPTS -->
        <script src="{{ asset('packages/metronic/global/scripts/app.min.js') }}" type="text/javascript"></script>
        <!-- END THEME GLOBAL SCRIPTS -->
        <!-- BEGIN PAGE LEVEL SCRIPTS -->
        <script src="{{ asset('packages/mnr_ehub/js/mnr_ehub.js') }}" type="text/javascript"></script>
        <!-- END PAGE LEVEL SCRIPTS -->
        <!-- BEGIN THEME LAYOUT SCRIPTS -->
        <!-- END THEME LAYOUT SCRIPTS -->
        <script type="text/javascript">
            
            mnreHub.init();
            
            @if ($message == 'Completed')
                toastr_call(1, 'Payment Successful');
            @else
                toastr_call(2, 'Payment Failed');
            @endif
                                
            function print()
            {
                var isChrome = !!window.chrome && !!window.chrome.webstore;
                
                var w = window.open('', 'div', 'height=400,width=600');
                w.document.write('<html><head><title>Topup Receipt</title>');  
                w.document.write('<style>.static-info{font-family:arial; font-size:14px; line-height:2.2;}.static-info .value{float:right; font-weight: 600;} .static-info .name{float:left;} .col-md-3{width:25%;} .col-md-9{width:75%;} .col-md-12{width:100%;}</style>');
                w.document.write('</head><body >');
                w.document.write('<img src="{{ asset($companyProfile["company_logo"]) }}" style="width:175px; padding-bottom:30px;">');
                w.document.write('<div class="col-md-12"><div class="static-info name"> {!! $companyProfile["header"] !!}</div></div>');
                w.document.write('<h4>Instant Credit Receipt</h4>');
                w.document.write($('#print-body').html());
                w.document.write('<div class="col-md-12">');
                    w.document.write('<div class="static-info name"> {!! $companyProfile["description"] !!} </div>');
                    w.document.write('<hr>');
                    w.document.write('<div class="static-info name"> {!! $companyProfile["footer"] !!} </div>');
                w.document.write('</div>');
                w.document.write('</body></html>');

                if(isChrome == true)
                {
                    setTimeout(function () 
                    { 
                        w.print();
                        w.close(); 
                    }, 500);
                }else
                {
                    w.print();
                    w.close(); 
                }
                return true;
            }
        </script>
    </body>
</html>