<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>                            
    <div class="portlet light portlet-fit">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo">
                    {{ $title }}
                </span>
            </div>
        </div>
        <div class="portlet-body">
            <div class="middle-content margin-top-40">
                <p>Enter a phone number you want to top-up</p>
                <input id="phone" type="tel">
                <div class="product-item cursor">
                    <span id="select_150" class="ribbon-featured display-hide" style="display: inline;">
                        <strong class="ribbon">Selected</strong>
                    </span>
                    <h4>
                        <span>PKR</span>
                        <span>93.00</span>
                    </h4>
                    <a href="javascript:;" class="select-option-link btn btn-select">Select Amount</a>
                    <p>
                        <span>EURO</span>
                        <span>{{ getGlobalValue('currency') }}1.00</span>
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 margin-top-20">
                    <div class="col-xs-6 col-sm-2">
                        <div class="product-item cursor">
                            <h4>
                                <span>PKR</span>
                                <span>93.00</span>
                            </h4>
                            <a href="javascript:;" class="select-option-link btn btn-select">Select Amount</a>
                            <p>
                                <span>EURO</span>
                                <span>{{ getGlobalValue('currency') }}1.00</span>
                            </p>
                        </div>
                    </div>
                    <div class="col-xs-6 col-sm-2">
                        <div class="product-item cursor">
                            <h4>
                                <span>PKR</span>
                                <span>93.00</span>
                            </h4>
                            <a href="javascript:;" class="select-option-link btn btn-select">Select Amount</a>
                            <p>
                                <span>EURO</span>
                                <span>{{ getGlobalValue('currency') }}1.00</span>
                            </p>
                        </div>
                    </div>
                    <div class="col-xs-6 col-sm-2">
                        <div class="product-item cursor">
                            <h4>
                                <span>PKR</span>
                                <span>93.00</span>
                            </h4>
                            <a href="javascript:;" class="select-option-link btn btn-select">Select Amount</a>
                            <p>
                                <span>EURO</span>
                                <span>{{ getGlobalValue('currency') }}1.00</span>
                            </p>
                        </div>
                    </div>
                    <div class="col-xs-6 col-sm-2">
                        <div class="product-item cursor">
                            <h4>
                                <span>PKR</span>
                                <span>93.00</span>
                            </h4>
                            <a href="javascript:;" class="select-option-link btn btn-select">Select Amount</a>
                            <p>
                                <span>EURO</span>
                                <span>{{ getGlobalValue('currency') }}1.00</span>
                            </p>
                        </div>
                    </div>
                    <div class="col-xs-6 col-sm-2">
                        <div class="product-item cursor">
                            <h4>
                                <span>PKR</span>
                                <span>93.00</span>
                            </h4>
                            <a href="javascript:;" class="select-option-link btn btn-select">Select Amount</a> 
                            <p>
                                <span>EURO</span>
                                <span>{{ getGlobalValue('currency') }}1.00</span>
                            </p>
                        </div>
                    </div>
                    <div class="col-xs-6 col-sm-2">
                        <div class="product-item cursor">
                            <h4>
                                <span>PKR</span>
                                <span>93.00</span>
                            </h4>
                            <a href="javascript:;" class="select-option-link btn btn-select">Select Amount</a>
                            <p>
                                <span>EURO</span>
                                <span>{{ getGlobalValue('currency') }}1.00</span>
                            </p>
                        </div>
                    </div>
                    <div class="col-md-12 margin-top-20 text-right">
                        <button class="btn red">Proceed to checkout</button>
                        <button class="btn dark" >+ Add another top-up</button>
                    </div>                                              
                </div>
            </div>
        </div>
    </div>
</div>
<style>
    .token.operator,
    .token.entity,
    .token.url,
    .language-css .token.string,
    .style .token.string,
    .token.variable {
      background: none; }

    input, button {
      height: 35px;
      margin: 0;
      padding: 6px 12px;
      border-radius: 2px;
      font-family: inherit;
      font-size: 100%;
      color: inherit; }
      input[disabled], button[disabled] {
        background-color: #eee; }

    input, select {
      border: 1px solid #c2cad8;
      width: 450px; 
      height: 50px;
      border-radius: 10px;
      font-size: 18px;
    }

    ::-webkit-input-placeholder {
      color: #BBB; }

    ::-moz-placeholder {
      /* Firefox 19+ */
      color: #BBB;
      opacity: 1; }

    :-ms-input-placeholder {
      color: #BBB; }

    button {
      color: #FFF;
      background-color: #428BCA;
      border: 1px solid #357EBD; }
      button:hover {
        background-color: #3276B1;
        border-color: #285E8E;
        cursor: pointer; }

    #result {
      margin-bottom: 100px; }

    @media (max-width: 360px) {
      input, select {
        width: auto; 
        height: auto;
      }
    }
</style>
<script type="text/javascript"> 
    $("#phone").intlTelInput({
        initialCountry: "auto",
        geoIpLookup: function(callback) {
            $.get('http://ipinfo.io', function() {}, "jsonp").always(function(resp) {
                var countryCode = (resp && resp.country) ? resp.country : "";
                callback(countryCode);
            });
        },
        utilsScript: "{{ asset('packages/mnr_ehub/js/utils.js') }}" // just for formatting/placeholders etc
    });
</script>