<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
            <span class="sr-only">Toggle navigation</span>
            <span class="toggle-icon">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </span>
        </button>
    </div>
</div>
<div class="col-md-3">
    <div class="page-sidebar">
        <nav class="navbar" role="navigation">
            <ul class="nav navbar-nav margin-bottom-35">
                <h4 class="unlocking">Categories</h4>
                @foreach($categories as $row)
                    @if ($loop->first)
                        <li class="active">
                    @else
                        <li>
                    @endif
                        <a href="javascript:;" id="{{ $row->id }}" class="category">
                            {{ $row->name }}
                        </a>
                    </li>
                @endforeach
            </ul>
        </nav>
    </div>
</div>
<div class="col-md-9">
    <div class="portlet light portlet-fit">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo">
                    {{ $title }}
                </span>
            </div>
        </div>
        <div class="portlet-body">                
            <div class="form-body">
                {{ Form::open(['url' => '/transactions/professional_service', 'method' => 'get', 'id' => 'professional_service', 'class' => 'form-horizontal']) }}
                    <div class="form-group margin-top-20">
                        <div class="col-md-5 margin-bottom-20">
                            {{ getMultipleCategories(5, $request['category_id']) }}
                        </div>
                        <div class="col-md-1">
                            <button type="button" id="search" class="btn btn-icon-only red"> <i class="fa fa-search"></i></button>
                        </div>
                    </div>                
                {{ Form::close() }}   
                @if($categories->count() > 0)
                    @foreach($categories as $category)
                        <h2 id="category_{{ $category->id }}" class="service-unlocking margin-bottom-30">{{ $category->name }}</h2>
                        @foreach($category->mnrServices as $row)
                            @if($loop->first)
                            <table class="table table-striped table-bordered table-hover">
                                <thead> 
                                    <tr>
                                        <th>Service Name</th>
                                        <th>Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                            @endif
                                    <tr>
                                        <td>
                                            @if($row->type == 1)
                                                <a href="{{ URL::route('mnr_service_detail', ['service_id' => $row->id]) }}" class="ajaxify">
                                                    {{ $row->name }}
                                                </a>
                                            @elseif($row->type == 2)
                                                <a href="{{ $row->url }}" target="_blank">{{ $row->name }}</a>
                                            @endif
                                        </td>
                                        <td>
                                            {{ $row->amount }}
                                            {{ ($row->amount_type == 'fixed')?getGlobalValue('currency'):'%' }}
                                        </td>
                                    </tr>
                            @if($loop->last)
                                </tbody>
                            </table>
                            @endif
                        @endforeach
                    @endforeach
                @else
                        No Records found
                @endif
            </div>
        </div>
    </div>    
</div>

<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();

//-----------------------------------Select2------------------------------------

        $('.select').select2({
            placeholder: "All",
            width: null,
            minimumResultsForSearch: 7
        }).on('change', function() {
            $(this).valid();
        });

//------------------------------Scroll To Category------------------------------

        $('.category').click(function()
        {
            App.scrollTo($('#category_'+$(this).attr('id')));
        });

//------------------------------------Lookup------------------------------------

        $('#search').click(function()
        {
            var val = $('#professional_service');
            lookup(val);
            return false;
        });        
    });
</script>