{{-- add fields --}}
{{ Form::open(["route" => 'users.profile.addfield', 'role' => 'form', 'id' => 'profile_field']) }}
    {{ Form::hidden('user_id', $user_profile->user_id) }}
    <div class="form-group">
        <div class="input-group select2-bootstrap-prepend">
            <span class="input-group-btn">
                <button type="button" class="btn btn-default add_profile_field" data-select2-open="single-prepend-text">
                    <span class="glyphicon glyphicon-plus-sign"></span>
                </button>
            </span>
            {{ Form::text('description', '', ['class' =>'form-control', 'placeholder' => 'Custom Field Name']) }}
        </div>
    </div>
{{ Form::close() }}

{{-- delete fields --}}
@foreach($custom_profile->getAllTypesWithValues() as $profile_data)
    {{ Form::open(["route" => 'users.profile.deletefield', 'name' => $profile_data->id, 'role' => 'form']) }}
        {{ Form::hidden('id', $profile_data->id) }}
        {{ Form::hidden('user_id',$user_profile->user_id) }}
        <div class="form-group">
            <div class="input-group">
                <span class="input-group-btn">
                    <button type="button" id="{{ $profile_data->id }}" class="btn btn-default delete_profile_field" style="background-color: #e1e5ec">
                        <span class="glyphicon glyphicon-minus-sign"></span>
                    </button>
                </span>
                {{ Form::text('profile_description', $profile_data->description, ['class' => 'form-control', 'readonly' => 'readonly']) }}
            </div>
        </div>
    {{ Form::close() }}
@endforeach