{{-- add permission --}}
{{ Form::open(['route' => 'users.edit.permission', 'role' => 'form', 'id' => 'permission', 'class' => 'form-horizontal']) }}
    {{ Form::hidden('id', $user->id) }}
    {{-- add permission operation --}}
    {{ Form::hidden('operation', 1) }}
    <div class="form-group">
        <div class="col-md-12">
            <div class="input-group select2-bootstrap-prepend">
                <span class="input-group-btn">
                    <button type="button" class="btn btn-default add_permission" data-select2-open="single-prepend-text">
                        <span class="glyphicon glyphicon-plus-sign"></span>
                    </button>
                </span>
                {{ Form::select('permissions', $permission_values, '', ['class' => 'form-control permission-select select2']) }}
            </div>
            <span class="font-red-mint">{{ $errors->first('permissions') }}</span>
        </div>
    </div>
    @if(! $user->exists)
        <span class="font-red-mint">You need to create the user first.</span>
    @endif
{{ Form::close() }}

{{-- remove permission --}}
@if( $presenter->permissions )
    @foreach($presenter->permissions_obj as $permission)
        {{ Form::open(['route' => 'users.edit.permission', 'name' => $permission->permission, 'role' => 'form', 'class' => 'form-horizontal']) }}
            {{ Form::hidden('permissions', $permission->permission) }}
            {{ Form::hidden('id', $user->id) }}
            {{-- add permission operation --}}
            {{ Form::hidden('operation', 0) }}
            <div class="form-group">
                <div class="col-md-12">
                    <div class="input-group">
                        <span class="input-group-btn">
                            <button type="button" id="{{ $permission->permission }}" class="btn btn-default delete_permission" style="background-color: #e1e5ec">
                                <span class="glyphicon glyphicon-minus-sign"></span>
                            </button>
                        </span>
                        {{ Form::text('permission_desc', $permission->description, ['class' => 'form-control', 'readonly' => 'readonly']) }}
                    </div>
                </div>    
            </div>
        {{ Form::close() }}
    @endforeach
@elseif($user->exists)
    <span class="font-red-mint">There is no permission associated to the user.</span>
@endif